<?php
/**
*
* This file is part of the french language pack for the phpBB Forum Software package.
* This file is translated by phpBB-fr.com <http://www.phpbb-fr.com>
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ « » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Traduit par <a href="http://www.phpbb-fr.com">phpBB-fr.com</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 janv. 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 janv. 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'fr',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/32x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 2,

	'1_DAY'			=> '1 jour',
	'1_MONTH'		=> '1 mois',
	'1_YEAR'		=> '1 an',
	'2_WEEKS'		=> '2 semaines',
	'3_MONTHS'		=> '3 mois',
	'6_MONTHS'		=> '6 mois',
	'7_DAYS'		=> '7 jours',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Votre compte est déjà activé.',
	'ACCOUNT_DEACTIVATED'			=> 'Votre compte a été désactivé manuellement et n’est réactivable que par un administrateur.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Votre compte n’a pas encore été activé.',
	'ACP'							=> 'Panneau d’administration',
	'ACP_SHORT'						=> 'PCA',
	'ACTIVE'						=> 'Actif',
	'ACTIVE_ERROR'					=> 'Le nom d’utilisateur indiqué est actuellement inactif. Si vous avez des problèmes pour activer votre compte, contactez l’administrateur du forum.',
	'ADMINISTRATOR'					=> 'Administrateur',
	'ADMINISTRATORS'				=> 'Administrateurs',
	'AGE'							=> 'Âge',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'Erreur AJAX',
	'AJAX_ERROR_TEXT'				=> 'Quelque chose s’est mal passé lors du traitement de votre demande.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Requête annulée par l’utilisateur.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Votre demande a expiré. Essayez à nouveau.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Quelque chose s’est mal passé lors du traitement de votre demande et le serveur a renvoyé une réponse invalide.',
	'ALLOWED'						=> 'Autorisé',
	'ALL_FILES'						=> 'Tous les fichiers',
	'ALL_FORUMS'					=> 'Tous les forums',
	'ALL_MESSAGES'					=> 'Tous les messages',
	'ALL_POSTS'						=> 'Tous',
	'ALL_TIMES'						=> 'Heures au format <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'Tous',
	'ALT_TEXT'						=> 'Texte alternatif',
	'AND'							=> 'et',
	'ARE_WATCHING_FORUM'			=> 'Vous surveillez maintenant les nouveaux messages de ce forum.',
	'ARE_WATCHING_TOPIC'			=> 'Vous surveillez maintenant les nouveaux messages de ce sujet.',
	'ASCENDING'						=> 'Croissant',
	'ATTACHMENTS'					=> 'Fichiers joints',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Le fichier image que vous essayez de joindre n’est pas valide.',
	'AUTHOR'						=> 'Auteur',
	'AUTH_NO_PROFILE_CREATED'		=> 'Impossible de créer le nouveau profil du membre.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Entrée de base de données non valide.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Le type de service founit au gestionnaire de service OAuth n’est pas valide.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'Le service OAuth n’a pas été créé.',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'Le jeton OAuth n’a pas été mémorisé.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'Le jeton OAuth n’a pas été mémorisé correctement.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Le transfert a été interrompu car le contenu du fichier a été identifié comme étant un vecteur potentiel d’attaque.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Ce fichier ne peut pas être affiché car l’extension <strong>%s</strong> n’est pas autorisée.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'L’avatar indiqué n’a pas pu être transféré car les données distantes semblent être invalides ou corrompues.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Le fichier avatar transféré est vide.',
	'AVATAR_INVALID_FILENAME'		=> '%s n’est pas un nom de fichier valide.',
	'AVATAR_NOT_UPLOADED'			=> 'L’avatar n’a pas pu être transféré.',
	'AVATAR_NO_TEMP_DIR'			=> 'Le répertoire temporaire n’existe pas ou n’est pas accessible en écriture.',
	'AVATAR_NO_SIZE'				=> 'Impossible de déterminer la largeur ou la hauteur de l’avatar lié, saisissez-les manuellement.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Le fichier n’a pu être que partiellement transféré.',
	'AVATAR_PHP_SIZE_NA'			=> 'Le fichier image de l’avatar est trop volumineux.<br />Le maximum réglé dans php.ini n’a pas pu être déterminé.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Le fichier image de l’avatar est trop volumineux. Le maximum autorisée est %1$d %2$s.<br />Notez que ce paramètre est inscrit dans php.ini et ne peut pas être dépassé.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'	=> 'Le fichier image de l’avatar n’a pas pu être transféré parce que le délai d’attente de la demande a expiré.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'Une extension PHP a arrêté le transfert du fichier.',
	'AVATAR_URL_INVALID'			=> 'L’adresse URL indiquée n’est pas valide.',
	'AVATAR_URL_NOT_FOUND'			=> 'Le fichier indiqué est introuvable.',
	'AVATAR_WRONG_FILESIZE'			=> 'Le fichier image de l’avatar doit être compris entre 0 et %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'L’avatar envoyé a une largeur de %5$s et une hauteur de %6$s. Les avatars doivent faire au moins %1$s de large et %2$s de haut, mais au plus %3$s de large et %4$s de haut.',

	'BACK_TO_TOP'			=> 'Haut',
	'BACK_TO_PREV'			=> 'Retour à la page précédente',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Votre adresse courriel a été bannie.',
	'BAN_TRIGGERED_BY_IP'	=> 'Votre adresse IP a été bannie.',
	'BAN_TRIGGERED_BY_USER'	=> 'Votre nom d’utilisateur a été banni.',
	'BBCODE_GUIDE'			=> 'Guide du BBCode',
	'BCC'					=> 'CCI',
	'BIRTHDAYS'				=> 'Anniversaires',
	'BOARD_BAN_PERM'		=> 'Vous avez été banni <strong>définitivement</strong> de ce forum.<br /><br />Contactez l’%2$sAdministrateur du forum%3$s pour plus d’informations.',
	'BOARD_BAN_REASON'		=> 'Raison du bannissement : <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Vous avez été banni de ce forum jusqu’au <strong>%1$s</strong>.<br /><br />Contactez l’%2$sAdministrateur du forum%3$s pour plus d’informations.',
	'BOARD_DISABLE'			=> 'Désolé, mais ce forum est actuellement indisponible.',
	'BOARD_DISABLED'		=> 'Ce forum est actuellement désactivé.',
	'BOARD_UNAVAILABLE'		=> 'Désolé, mais le forum est temporairement indisponible, réessayez dans quelques minutes.',
	'BROWSING_FORUM'		=> 'Utilisateurs parcourant ce forum : %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Utilisateurs parcourant ce forum : %2$s et %1$d invité',
		2	=> 'Utilisateurs parcourant ce forum : %2$s et %1$d invités',
	),
	'BUTTON_EDIT'			=> 'Modifier',
	'BUTTON_FORUM_LOCKED'	=> 'Verrouillé',
	'BUTTON_NEW_TOPIC'		=> 'Nouveau sujet',
	'BUTTON_PM'				=> 'MP',
	'BUTTON_PM_FORWARD'		=> 'Transférer',
	'BUTTON_PM_NEW'			=> 'Nouveau MP',
	'BUTTON_PM_REPLY'		=> 'Répondre',
	'BUTTON_PM_REPLY_ALL'	=> 'Répondre à tous',
	'BUTTON_POST_REPLY'		=> 'Répondre',
	'BUTTON_QUOTE'			=> 'Citer',
	'BUTTON_TOPIC_LOCKED'	=> 'Verrouillé',
	'BYTES'					=> 'Octets',
	'BYTES_SHORT'			=> 'o',

	'CANCEL'				=> 'Annuler',
	'CHANGE'				=> 'Modifier',
	'CHANGE_FONT_SIZE'		=> 'Modifier la taille de la police',
	'CHANGING_PREFERENCES'	=> 'Modifie les préférences du forum',
	'CHANGING_PROFILE'		=> 'Modifie son profil',
	'CHARACTERS'			=> array(
		1	=> '%d caractère',
		2	=> '%d caractères',
	),
	'COLLAPSE_VIEW'			=> 'Réduire la vue',
	'CLOSE_WINDOW'			=> 'Fermer la fenêtre',
	'COLOUR_SWATCH'			=> 'Palette de couleurs',
	'COLON'					=> ' :',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Confirmer',
	'CONFIRM_CODE'			=> 'Code de confirmation',
	'CONFIRM_CODE_EXPLAIN'	=> 'Saisissez le code exactement comme vous le voyez dans l’image. Notez que le code n’est pas sensible à la casse.',
	'CONFIRM_CODE_WRONG'	=> 'Le code de confirmation que vous avez saisi est incorrect.',
	'CONFIRM_OPERATION'		=> 'Êtes-vous sûr de vouloir effectuer cette opération ?',
	'CONFIRM_AVATAR_DELETE' => 'Êtes-vous sûr de vouloir supprimer cet avatar ?',
	'CONGRATULATIONS'		=> 'Félicitations à',
	'CONNECTION_FAILED'		=> 'La connexion a échoué.',
	'CONNECTION_SUCCESS'	=> 'Vous êtes connecté !',
	'CONTACT'				=> 'Contact',
	'CONTACT_USER'			=> 'Contacter %s',
	'CONTACT_US'			=> 'Nous contacter',
	'COOKIE_CONSENT_INFO'	=> 'En savoir plus',
	'COOKIE_CONSENT_MSG'	=> 'En poursuivant votre navigation, vous acceptez l’utilisation de cookies.',
	'COOKIE_CONSENT_OK'		=> 'OK',
	'COOKIE_CONSENT_HREF'	=> 'https://www.cnil.fr/fr/cookies-traceurs-que-dit-la-loi',
	'COOKIES_DELETED'		=> 'Tous les cookies du forum ont été supprimés.',
	'CURRENT_TIME'			=> 'Nous sommes le %s',

	'DAY'					=> 'Jour',
	'DAYS'					=> 'jours',
	'DELETE'				=> 'Supprimer',
	'DELETE_ALL'			=> 'Tout supprimer',
	'DELETE_COOKIES'		=> 'Supprimer les cookies du forum',
	'DELETE_MARKED'			=> 'Supprimer la sélection',
	'DELETE_POST'			=> 'Supprimer le message',
	'DELIMITER'				=> 'Séparateur',
	'DESCENDING'			=> 'Décroissant',
	'DISABLED'				=> 'Désactivé',
	'DISPLAY'				=> 'Afficher',
	'DISPLAY_GUESTS'		=> 'Afficher les invités',
	'DISPLAY_MESSAGES'		=> 'Afficher les messages postés depuis',
	'DISPLAY_POSTS'			=> 'Afficher les messages postés depuis',
	'DISPLAY_TOPICS'		=> 'Afficher les sujets postés depuis',
	'DOWNLOADED'			=> 'Téléchargé',
	'DOWNLOADING_FILE'		=> 'Téléchargement en cours',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Pas encore téléchargé',
		1	=> 'Téléchargé %d fois',
		2	=> 'Téléchargé %d fois',
	),

	'EDIT_POST'							=> 'Modifier le message',
	'ELLIPSIS'							=>	'…',
	'EMAIL'								=> 'Courriel', 	// Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Adresse courriel',
	'EMAIL_INVALID_EMAIL'				=> 'L’adresse courriel que vous avez saisie n’est pas valide.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Un problème est survenu lors de l’envoi du courriel à la <strong>ligne %1$s</strong>. Réponse : %2$s.',
	'EMPTY_SUBJECT'						=> 'Vous devez indiquer un titre pour poster un nouveau sujet.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Vous devez indiquer un sujet quand vous envoyez un nouveau message.',
	'ENABLED'							=> 'Activé',
	'ENCLOSURE'							=> 'Clôture',
	'ENTER_USERNAME'					=> 'Saisissez le nom d’utilisateur',
	'ERR_CHANGING_DIRECTORY'			=> 'Impossible de changer de répertoire.',
	'ERR_CONNECTING_SERVER'				=> 'Erreur de connexion au serveur.',
	'ERR_JAB_AUTH'						=> 'Impossible de s’authentifier sur le serveur Jabber.',
	'ERR_JAB_CONNECT'					=> 'Impossible de se connecter sur le serveur Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Le nom d’utilisateur ou le mot de passe indiqué est incorrect.',
	'ERR_UNWATCHING'					=> 'Une erreur est survenue lors de l’arrêt de la surveillance.',
	'ERR_WATCHING'						=> 'Une erreur est survenue lors de l’activation de la surveillance.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Le chemin phpBB indiqué ne semble pas être valide.',
	'ERROR'								=> 'Erreur',
	'EXPAND_VIEW'						=> 'Étendre la vue',
	'EXTENSION'							=> 'Extension',
	'EXTENSION_DISABLED'				=> 'L’extension <strong>%s</strong> n’est pas activée.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'L’extension <strong>%s</strong> a été désactivée et ne peut plus être affichée.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'L’extension <strong>%s</strong> n’existe pas.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Foire aux questions (Questions posées fréquemment)',
	'FEATURE_NOT_AVAILABLE'	=> 'La fonctionnalité demandée n’est pas disponible sur ce forum.',
	'FILENAME'				=> 'Nom',
	'FILESIZE'				=> 'Taille',
	'FILEDATE'				=> 'Date',
	'FILE_COMMENT'			=> 'Commentaire',
	'FILE_CONTENT_ERR'		=> 'Impossible de lire le contenu du fichier : %s',
	'FILE_JSON_DECODE_ERR'	=> 'Impossible de décoder le fichier JSON : %s',
	'FILE_NOT_FOUND'		=> 'Le fichier recherché est introuvable : %s',
	'FIND_USERNAME'			=> 'Rechercher un membre',
	'FOLDER'				=> 'Dossier',
	'FORGOT_PASS'			=> 'J’ai oublié mon mot de passe',
	'FORM_INVALID'			=> 'Le formulaire envoyé n’est pas valide. Essayez à nouveau.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'Les forums ont été marqués comme lus.',
	'FORUM_CAT'				=> 'Catégorie du forum',
	'FORUM_INDEX'			=> 'Index du forum',
	'FORUM_LINK'			=> 'Forum-lien',
	'FORUM_LOCATION'		=> 'Localisation sur le forum',
	'FORUM_LOCKED'			=> 'Forum verrouillé',
	'FORUM_RULES'			=> 'Règles du forum',
	'FORUM_RULES_LINK'		=> 'Cliquez pour voir les règles du forum',
	'FROM'					=> 'de',
	'FSOCK_DISABLED'		=> 'Impossible de finir cette opération car la fonction <var>fsockopen</var> est désactivée ou le serveur requis n’a pas pu être trouvé.',
	'FSOCK_TIMEOUT'			=> 'Le temps d’attente a été dépassé lors de la lecture du flux réseau.',

	'FTP_FSOCK_HOST'				=> 'Serveur FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Serveur FTP utilisé pour se connecter à votre site.',
	'FTP_FSOCK_PASSWORD'			=> 'Mot de passe FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Mot de passe pour votre compte FTP.',
	'FTP_FSOCK_PORT'				=> 'Port FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port utilisé pour se connecter à votre serveur.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Chemin vers phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Chemin depuis la racine vers votre forum phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'Temps d’attente FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'La durée en secondes pendant laquelle le système attendra une réponse de votre serveur.',
	'FTP_FSOCK_USERNAME'			=> 'Nom d’utilisateur FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nom d’utilisateur utilisé pour se connecter à votre serveur.',

	'FTP_HOST'					=> 'Serveur FTP',
	'FTP_HOST_EXPLAIN'			=> 'Serveur FTP utilisé pour se connecter à votre site.',
	'FTP_PASSWORD'				=> 'Mot de passe FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Mot de passe pour votre compte FTP.',
	'FTP_PORT'					=> 'Port FTP',
	'FTP_PORT_EXPLAIN'			=> 'Port utilisé pour se connecter à votre serveur.',
	'FTP_ROOT_PATH'				=> 'Chemin vers phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Chemin depuis la racine vers votre forum phpBB.',
	'FTP_TIMEOUT'				=> 'Temps d’attente FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'La durée en secondes que le système attendra pour une réponse de votre serveur.',
	'FTP_USERNAME'				=> 'Nom d’utilisateur FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Nom d’utilisateur utilisé pour se connecter à votre serveur.',

	'GENERAL_ERROR'				=> 'Erreur générale',
	'GB'						=> 'Go',
	'GIB'						=> 'Gio',
	'GO'						=> 'Aller',
	'GOOGLEPLUS'				=> 'Google+',
	'GOTO_FIRST_POST'			=> 'Aller au premier message',
	'GOTO_LAST_POST'			=> 'Aller au dernier message',
	'GOTO_PAGE'					=> 'Aller à la page',
	'GROUP'						=> 'Groupe',
	'GROUPS'					=> 'Groupes',
	'GROUP_ERR_TYPE'			=> 'Le type de groupe indiqué est inapproprié.',
	'GROUP_ERR_USERNAME'		=> 'Aucun nom de groupe indiqué.',
	'GROUP_ERR_USER_LONG'		=> 'Les noms de groupe ne peuvent pas dépasser 60 caractères. Le nom du groupe indiqué est trop long.',
	'GUEST'						=> 'Invité',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'Il y a %d invité en ligne',
		2	=> 'Il y a %d invités en ligne',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d invité',
		2	=> '%d invités',
	),
	'G_ADMINISTRATORS'			=> 'Administrateurs',
	'G_BOTS'					=> 'Robots',
	'G_GUESTS'					=> 'Invités',
	'G_REGISTERED'				=> 'Utilisateurs enregistrés',
	'G_REGISTERED_COPPA'		=> 'Utilisateurs COPPA enregistrés',
	'G_GLOBAL_MODERATORS'		=> 'Modérateurs globaux',
	'G_NEWLY_REGISTERED'		=> 'Nouveaux utilisateurs enregistrés',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d membre invisible',
		2	=> '%d membres invisibles',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d invisible',
		2	=> '%d invisibles',
	),
	'HIDE_GUESTS'					=> 'Masquer les invités',
	'HIDE_ME'						=> 'Cacher mon statut en ligne pour cette session',
	'HOURS'							=> 'Heures',
	'HOME'							=> 'Accueil',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Si',
	'IMAGE'						=> 'Image',
	'IMAGE_FILETYPE_INVALID'	=> 'Le type de fichier image %d pour le type mime %s n’est pas supporté.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Type de fichier image incorrect : l’extension %1$s était attendue mais l’extension %2$s a été trouvée.',
	'IN'						=> 'dans',
	'INACTIVE'					=> 'Inactif',
	'INDEX'						=> 'Page d’index',
	'INFORMATION'				=> 'Informations',
	'INSECURE_REDIRECT'			=> 'Vous avez tenté de rediriger vers une URL potentiellement dangereuse.',
	'INTERESTS'					=> 'Centres d’intérêt',
	'INVALID_DIGEST_CHALLENGE'	=> 'Défi invalide.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> est peut-être une adresse invalide ?',
	'INVALID_FEED_ATTACHMENTS'	=> 'Le flux sélectionné a tenté de récupérer la liste des fichiers joints avec des paramètres non valides.',
	'INVALID_PLURAL_RULE'		=> 'La règle de pluriel choisie n’est pas valide. La valeur doit être un entier compris entre 0 et 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Votre IP %1$s a été bloquée car elle est dans la liste noire. Pour plus d’informations, consultez <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Enregistré le',
	'JUMP_PAGE'				=> 'Saisissez le numéro de page où vous souhaitez aller.',
	'JUMP_TO'				=> 'Aller à',
	'JUMP_TO_PAGE'			=> 'Aller à la page',
	'JUMP_TO_PAGE_CLICK'	=> 'Cliquer pour aller à la page…',

	'KB'					=> 'Ko',
	'KIB'					=> 'Kio',

	'LAST_POST'							=> 'Dernier message',
	'LAST_UPDATED'						=> 'Dernière mise à jour',
	'LAST_VISIT'						=> 'Dernière visite',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Extension LDAP indisponible.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Impossible de se connecter au serveur LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Une erreur est survenue pendant la recherche du répertoire LDAP.',
	'LEGEND'							=> 'Légende',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'La recherche dynamique n’est pas autorisée.',
	'LOADING'							=> 'Chargement en cours…',
	'LOCATION'							=> 'Localisation',
	'LOCK_POST'							=> 'Verrouiller le message',
	'LOCK_POST_EXPLAIN'					=> 'Empêche la modification du message',
	'LOCK_TOPIC'						=> 'Verrouiller le sujet',
	'LOGIN'								=> 'Connexion',
	'LOGIN_CHECK_PM'					=> 'Se connecter pour vérifier ses messages privés.',
	'LOGIN_CONFIRMATION'				=> 'Confirmation de connexion',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Pour éviter une usurpation des comptes, l’administrateur du forum exige que vous saisissiez un code de confirmation visuel après un certain nombre d’échecs. Le code est indiqué dans l’image que vous devez voir ci-dessous. Si vous êtes déficient visuel ou que vous ne pouvez pas lire ce code, contactez %sl’administrateur%s du forum.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Vous avez dépassé le nombre maximum autorisé de tentatives de connexion. En plus de votre nom d’utilisateur et de votre mot de passe, vous devez également résoudre le CAPTCHA ci-dessous.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Vous n’avez pas été authentifié par Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'Le service OAuth demandé n’existe pas.',
	'LOGIN_ERROR_PASSWORD'				=> 'Vous avez indiqué un mot de passe incorrect. Vérifiez votre mot de passe et réessayez. Si vous continuez à rencontrer des problèmes, contactez l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Il n’a pas été possible de convertir votre mot de passe lors de la mise à jour du forum. %sRedemandez un mot de passe%s. Si le problème persiste, contactez l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Vous avez indiqué un nom d’utilisateur incorrect. Vérifiez votre nom d’utilisateur et réessayez. Si vous continuez à rencontrer des problèmes, contactez l’%sadministrateur du forum%s.',
	'LOGIN_FORUM'						=> 'Pour lire ou poster dans ce forum, vous devez saisir son mot de passe.',
	'LOGIN_INFO'						=> 'Vous devez être enregistré pour vous connecter. L’enregistrement ne prend que quelques secondes et augmente vos possibilités. L’administrateur du forum peut également accorder des permissions additionnelles aux membres du forum. Avant de vous enregistrer, assurez-vous d’avoir pris connaissance de nos conditions d’utilisation et de notre politique de vie privée. Assurez-vous de bien lire tout le règlement du forum.',
	'LOGIN_VIEWFORUM'					=> 'L’administrateur du forum exige que vous soyez enregistré et connecté pour lire ce forum.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Pour modifier des messages dans ce forum, vous devez être enregistré et connecté.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Pour consulter la liste des utilisateurs en ligne, vous devez être enregistré et connecté.',
	'LOGIN_REQUIRED'					=> 'Vous devez vous connecter pour effectuer cette action.',
	'LOGOUT'							=> 'Déconnexion',
	'LOGOUT_USER'						=> 'Déconnexion [ %s ]',
	'LOG_ME_IN'							=> 'Se souvenir de moi',

	'MAIN'					=> 'Principal',
	'MARK'					=> 'Cocher',
	'MARK_ALL'				=> 'Tout cocher',
	'MARK_ALL_READ'			=> 'Marquer tout comme lu',
	'MARK_FORUMS_READ'		=> 'Marquer tous les forums comme lus',
	'MARK_READ'				=> 'Marquer comme lu',
	'MARK_SUBFORUMS_READ'	=> 'Marquer tous les sous-forums comme lus',
	'MB'					=> 'Mo',
	'MIB'					=> 'Mio',
	'MCP'					=> 'Panneau de modération',
	'MCP_SHORT'				=> 'PCM',
	'MEMBERLIST'			=> 'Membres',
	'MEMBERLIST_EXPLAIN'	=> 'Voir la liste complète des membres',
	'MERGE'					=> 'Fusionner',
	'MERGE_POSTS'			=> 'Déplacer les messages',
	'MERGE_TOPIC'			=> 'Fusionner le sujet',
	'MESSAGE'				=> 'Message',
	'MESSAGES'				=> 'Messages',
	'MESSAGES_COUNT'		=> array(
		1	=> '%d message',
		2	=> '%d messages',
	),
	'MESSAGE_BODY'			=> 'Corps du message',
	'MINUTES'				=> 'Minutes',
	'MODERATE'				=> 'Modérer',
	'MODERATOR'				=> 'Modérateur',
	'MODERATORS'			=> 'Modérateurs',
	'MODULE_NOT_ACCESS'		=> 'Module non accessible',
	'MODULE_NOT_FIND'		=> 'Impossible de trouver le module « %s »',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Le fichier du module « %s » ne contient pas la classe [%s].',
	'MONTH'					=> 'Mois',
	'MOVE'					=> 'Déplacer',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Le membre enregistré le plus récent est <strong>%s</strong>.',
	'NEW_MESSAGE'				=> 'Nouveau message',
	'NEW_MESSAGES'				=> 'Nouveaux messages',
	'NEW_POST'					=> 'Nouveau message',	// Not used anymore
	'NEW_POSTS'					=> 'Nouveaux messages',	// Not used anymore
	'NEXT'						=> 'Suivante',		// Used in pagination
	'NEXT_STEP'					=> 'Suivant',
	'NEVER'						=> 'Jamais',
	'NO'						=> 'Non',
	'NO_NOTIFICATIONS'			=> 'Vous n’avez pas de notification.',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Vous n’êtes pas autorisé à gérer ce groupe.',
	'NOT_AUTHORISED'			=> 'Vous n’êtes pas autorisé à accéder à cette partie du forum.',
	'NOT_WATCHING_FORUM'		=> 'Vous ne surveillez plus ce forum.',
	'NOT_WATCHING_TOPIC'		=> 'Vous ne surveillez plus ce sujet.',
	'NOTIFICATIONS'				=> 'Notifications',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Réponse</strong> de %1$s dans le sujet ajouté aux favoris :',
	),
	'NOTIFICATION_FORUM'				=> '<em>Forum :</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Adhésion au groupe</strong> demandée par %1$s pour rejoindre le groupe %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Adhésion au groupe approuvée</strong> pour rejoindre le groupe %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'La méthode « %s » ne fait pas référence à une méthode de notification valide.',
	'NOTIFICATION_PM'					=> '<strong>Message privé</strong> de %1$s :',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Réponse</strong> de %1$s dans le sujet :',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Message approuvé</strong> :',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Message désapprouvé</strong> :',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Message en attente d’approbation</strong> créé par %1$s :',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Citation</strong> de %1$s dans :',
	),
	'NOTIFICATION_REFERENCE'			=> '« %1$s »',
	'NOTIFICATION_REASON'				=> '<em>Raison :</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Message privé rapporté</strong> par %1$s :',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Message rapporté</strong> par %1$s :',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Rapport clôturé</strong> par %1$s pour :',
	'NOTIFICATION_TOPIC'				=> '<strong>Nouveau message</strong> créé par %1$s :',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Sujet approuvé</strong> :',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Sujet désapprouvé</strong> :',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Sujet en attente d’approbation</strong> créé par %1$s :',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'Le type de notification « %s » est absent du système de fichier.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Activation de compte requise</strong> pour le membre désactivé ou nouvellement enregistré : « %1$s ».',
	// Used in conjuction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'plusieurs autres membres',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d autres membres',
	),
	'NOTIFY_ADMIN'				=> 'Contactez l’administrateur du forum ou le webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Contactez l’administrateur du forum ou le webmaster : <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Vous n’êtes pas autorisé à accéder à ce fichier.',
	'NO_ACTION'					=> 'Aucune action indiquée.',
	'NO_ADMINISTRATORS'			=> 'Il n’existe aucun administrateur.',
	'NO_AUTH_ADMIN'				=> 'Vous n’avez pas les permissions d’administration et ne pouvez donc pas accéder au panneau d’administration.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Vous ne pouvez pas vous ré-authentifier avec un compte différent.',
	'NO_AUTH_OPERATION'			=> 'Vous n’avez pas les permissions nécessaires pour accomplir cette opération.',
	'NO_AVATARS'				=> 'Pas d’avatar de disponible',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Impossible de se connecter au serveur smtp : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Pas d’anniversaire à fêter aujourd’hui',
	'NO_EMAIL_MESSAGE'			=> 'Le contenu de ce courriel est vide.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Impossible de récupérer les codes de réponse du serveur.',
	'NO_EMAIL_SUBJECT'			=> 'Aucun sujet n’a été indiqué.',
	'NO_FORUM'					=> 'Le forum que vous avez tenté d’atteindre n’existe pas.',
	'NO_FORUMS'					=> 'Aucun forum.',
	'NO_GROUP'					=> 'Le groupe demandé n’existe pas.',
	'NO_GROUP_MEMBERS'			=> 'Aucun membre dans ce groupe.',
	'NO_IPS_DEFINED'			=> 'Aucune IP ou nom d’hôte',
	'NO_MEMBERS'				=> 'Aucun membre trouvé pour ce critère de recherche.',
	'NO_MESSAGES'				=> 'Pas de message',
	'NO_MODE'					=> 'Pas de mode indiqué.',
	'NO_MODERATORS'				=> 'Il n’existe aucun modérateur.',
	'NO_NEW_MESSAGES'			=> 'Pas de nouveau message',
	'NO_NEW_POSTS'				=> 'Pas de nouveau message',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Aucun utilisateur enregistré',
	'NO_POSTS'					=> 'Pas de message',
	'NO_POSTS_TIME_FRAME'		=> 'Aucun message n’a été posté dans ce sujet pour la période indiquée.',
	'NO_FEED_ENABLED'			=> 'Les flux ne sont pas disponibles sur ce forum.',
	'NO_FEED'					=> 'Le flux demandé n’est pas disponible.',
	'NO_STYLE_DATA'				=> 'Impossible de récupérer les données de style',
	'NO_SUBJECT'				=> 'Aucun sujet indiqué',			// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'La recherche indiquée n’existe pas.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Aucune méthode d’authentification supportée.',
	'NO_TOPIC'					=> 'Le sujet demandé n’existe pas.',
	'NO_TOPIC_FORUM'			=> 'Le sujet ou le forum n’existe plus.',
	'NO_TOPICS'					=> 'Il n’y a aucun sujet ou message dans ce forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Aucun sujet n’a été posté dans ce forum pour la période indiquée.',
	'NO_UNREAD_POSTS'			=> 'Aucun message non lu',
	'NO_UPLOAD_FORM_FOUND'		=> 'Le transfert a commencé mais aucun fichier valide n’a été trouvé.',
	'NO_USER'					=> 'Le membre demandé n’existe pas.',
	'NO_USERS'					=> 'Les membres demandés n’existent pas.',
	'NO_USER_SPECIFIED'			=> 'Aucun nom d’utilisateur indiqué.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d fichier joint',
		2	=> '%d fichiers joints',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Aucun message en attente',	// 0
		1			=> '1 message en attente',		// 1
		2			=> '%d messages en attente',		// 2+
	),

	'OCCUPATION'				=> 'Emploi',
	'OFFLINE'					=> 'Hors ligne',
	'ONLINE'					=> 'En ligne',
	'ONLINE_BUDDIES'			=> 'Amis en ligne',
	// "... : x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'Au total il y a <strong>%1$d</strong> utilisateur en ligne : %2$s et %3$s',
		2	=> 'Au total il y a <strong>%1$d</strong> utilisateurs en ligne : %2$s et %3$s',
	),
	// "... : x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'Au total il y a <strong>%1$d</strong> utilisateur en ligne : %2$s, %3$s et %4$s',
		2	=> 'Au total il y a <strong>%1$d</strong> utilisateurs en ligne : %2$s, %3$s et %4$s',
	),
	'OPTIONS'					=> 'Options',

	'PAGE_NOT_FOUND'		=> 'La page demandée n’a pas été trouvée.',
	'PAGE_OF'				=> 'Page <strong>%1$d</strong> sur <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Page %s',
	'PASSWORD'				=> 'Mot de passe',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d pixel',
		2	=> '%d pixels',
	),
	'PLEASE_WAIT'			=> 'Patientez.',
	'PM'					=> 'MP',
	'PM_REPORTED'			=> 'Cliquer pour voir le rapport',
	'POSTING_MESSAGE'		=> 'Poste un message dans %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Rédige un message privé',
	'POST'					=> 'Message',
	'POST_ANNOUNCEMENT'		=> 'Annonce',
	'POST_STICKY'			=> 'Sujet épinglé',
	'POSTED'				=> 'Posté',
	'POSTED_IN_FORUM'		=> 'Dans',
	'POSTED_ON_DATE'		=> 'le',
	'POSTS'					=> 'Messages',
	'POSTS_UNAPPROVED'		=> 'Au moins un message de ce sujet n’a pas été approuvé.',
	'POSTS_UNAPPROVED_FORUM'=> 'Au moins un message de ce forum n’a pas été approuvé.',
	'POST_BY_AUTHOR'		=> 'par',
	'POST_BY_FOE'			=> '<strong>%1$s</strong>, qui est actuellement sur votre liste de membres ignorés, a posté ce message.',
	'POST_DISPLAY'			=> '%1$sAfficher ce message%2$s.',
	'POST_DAY'				=> '%.2f messages par jour',
	'POST_DELETED_ACTION'	=> 'Message supprimé :',
	'POST_DELETED'			=> 'Ce message a été supprimé.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> a supprimé le message de <strong>%1$s</strong> le %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> a supprimé le message de <strong>%1$s</strong> le %3$s pour la raison suivante : %4$s',
	'POST_DETAILS'			=> 'Détails',
	'POST_NEW_TOPIC'		=> 'Poster un nouveau sujet',
	'POST_PCT'				=> '%.2f%% de tous les messages',
	'POST_PCT_ACTIVE'		=> '%.2f%% des messages du membre',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% de vos messages',
	'POST_REPLY'			=> 'Répondre',
	'POST_REPORTED'			=> 'Cliquer pour voir le rapport',
	'POST_SUBJECT'			=> 'Sujet du message',
	'POST_TIME'				=> 'Date',
	'POST_TOPIC'			=> 'Écrire un nouveau sujet',
	'POST_UNAPPROVED_ACTION'	=> 'Message en attente d’approbation :',
	'POST_UNAPPROVED'		=> 'Ce message n’a pas été approuvé.',
	'POWERED_BY'			=> 'Développé par %s',
	'PREVIEW'				=> 'Aperçu',
	'PREVIOUS'				=> 'Précédente',				// Used in pagination
	'PREVIOUS_STEP'			=> 'Précédente',
	'PRIVACY'				=> 'Politique de vie privée',
	'PRIVATE_MESSAGE'		=> 'Message privé',
	'PRIVATE_MESSAGES'		=> 'Messages privés',
	'PRIVATE_MESSAGING'		=> 'Messagerie privée',
	'PROFILE'				=> 'Panneau de l’utilisateur',

	'QUICK_LINKS'			=> 'Accès rapide',

	'RANK'						=> 'Rang',
	'READING_FORUM'				=> 'Consulte les sujets dans %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Consulte une annonce globale',
	'READING_LINK'				=> 'Consulte le lien du forum %s',
	'READING_TOPIC'				=> 'Consulte un sujet dans %s',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Raison',
	'RECORD_ONLINE_USERS'		=> 'Le record du nombre d’utilisateurs en ligne est de <strong>%1$s</strong>, le %2$s',
	'REDIRECT'					=> 'Rediriger',
	'REDIRECTS'					=> 'Nombre de redirections',
	'REGISTER'					=> 'S’enregistrer',
	'REGISTERED_USERS'			=> 'Membres :',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'Il y a %1$d membre et %2$s en ligne',
		2	=> 'Il y a %1$d membres et %2$s en ligne',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d enregistré',
		2	=> '%d enregistrés',
	),
	'REMOVE'					=> 'Supprimer',
	'REMOVE_INSTALL'			=> 'Pour finaliser l’installation du forum, supprimez, déplacez ou renommez le répertoire « install ». Si ce répertoire est détecté, seul le panneau d’administration (PCA) sera accessible.',
	'REPLIES'					=> 'Réponses',
	'REPLY_WITH_QUOTE'			=> 'Répondre en citant le message',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Répond à une annonce globale',
	'REPLYING_MESSAGE'			=> 'Répond à un message dans %s',
	'REPORT_BY'					=> 'Rapporté par',
	'REPORT_POST'				=> 'Rapporter le message',
	'REPORTING_POST'			=> 'Rapporter un message',
	'RESEND_ACTIVATION'			=> 'Renvoyer le courriel de confirmation',
	'RESET'						=> 'Réinitialiser',
	'RESTORE_PERMISSIONS'		=> 'Rétablir les permissions',
	'RETURN_INDEX'				=> '%sRetourner à l’index du forum%s',
	'RETURN_FORUM'				=> '%sRetourner au dernier forum visité%s',
	'RETURN_PAGE'				=> '%sRetourner à la page précédente%s',
	'RETURN_TOPIC'				=> '%sRetourner au dernier sujet visité%s',
	'RETURN_TO'					=> 'Retourner vers « %s »',
	'RETURN_TO_INDEX'			=> 'Retourner à l’index du forum',
	'FEED'						=> 'Flux',
	'FEED_NEWS'					=> 'Nouvelles informations',
	'FEED_TOPICS_ACTIVE'		=> 'Sujets actifs',
	'FEED_TOPICS_NEW'			=> 'Nouveaux sujets',
	'RULES_ATTACH_CAN'			=> 'Vous <strong>pouvez</strong> joindre des fichiers',
	'RULES_ATTACH_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> joindre des fichiers',
	'RULES_DELETE_CAN'			=> 'Vous <strong>pouvez</strong> supprimer vos messages',
	'RULES_DELETE_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> supprimer vos messages',
	'RULES_DOWNLOAD_CAN'		=> 'Vous <strong>pouvez</strong> télécharger des fichiers joints',
	'RULES_DOWNLOAD_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> télécharger des fichiers joints',
	'RULES_EDIT_CAN'			=> 'Vous <strong>pouvez</strong> modifier vos messages',
	'RULES_EDIT_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> modifier vos messages',
	'RULES_LOCK_CAN'			=> 'Vous <strong>pouvez</strong> verrouiller vos sujets',
	'RULES_LOCK_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> verrouiller vos sujets',
	'RULES_POST_CAN'			=> 'Vous <strong>pouvez</strong> poster de nouveaux sujets',
	'RULES_POST_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> poster de nouveaux sujets',
	'RULES_REPLY_CAN'			=> 'Vous <strong>pouvez</strong> répondre aux sujets',
	'RULES_REPLY_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> répondre aux sujets',
	'RULES_VOTE_CAN'			=> 'Vous <strong>pouvez</strong> participer aux votes',
	'RULES_VOTE_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> participer aux votes',

	'SEARCH'					=> 'Rechercher',
	'SEARCH_MINI'				=> 'Recherche…',
	'SEARCH_ADV'				=> 'Recherche avancée',
	'SEARCH_ADV_EXPLAIN'		=> 'Voir les options de recherche avancée',
	'SEARCH_KEYWORDS'			=> 'Recherche par mots-clés',
	'SEARCHING_FORUMS'			=> 'Recherche dans les forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'Sujets actifs',
	'SEARCH_FOR'				=> 'Rechercher',
	'SEARCH_FORUM'				=> 'Dans ce forum…',
	'SEARCH_NEW'				=> 'Nouveaux messages',
	'SEARCH_POSTS_BY'			=> 'Rechercher les messages de',
	'SEARCH_SELF'				=> 'Mes messages',
	'SEARCH_TOPIC'				=> 'Dans ce sujet…',
	'SEARCH_UNANSWERED'			=> 'Sujets sans réponse',
	'SEARCH_UNREAD'				=> 'Messages non lus',
	'SEARCH_USER_POSTS'			=> 'Rechercher les messages du membre',
	'SECONDS'					=> 'secondes',
	'SEE_ALL'					=> 'Tout voir',
	'SELECT'					=> 'Sélectionner',
	'SELECT_ALL_CODE'			=> 'Tout sélectionner',
	'SELECT_DESTINATION_FORUM'	=> 'Choisissez un forum de destination',
	'SELECT_FORUM'				=> 'Sélectionner un forum',
	'SEND_EMAIL'				=> 'Envoyer un courriel',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Envoyer un courriel à %s',
	'SEND_PRIVATE_MESSAGE'		=> 'Envoyer un message privé',
	'SETTINGS'					=> 'Paramètres',
	'SIGNATURE'					=> 'Signature',
	'SKIP'						=> 'Vers le contenu',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Le serveur SMTP ne peut pas vous identifier.',
	'SORRY_AUTH_READ'			=> 'Vous n’êtes pas autorisé à lire ce forum.',
	'SORRY_AUTH_READ_TOPIC'		=> 'Vous n’êtes pas autorisé à lire ce sujet.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Vous n’êtes pas autorisé à télécharger ce fichier joint.',
	'SORT_BY'					=> 'Trier par',
	'SORT_DIRECTION'			=> 'Ordre',
	'SORT_JOINED'				=> 'Date d’enregistrement',
	'SORT_LOCATION'				=> 'Localisation',
	'SORT_OPTIONS'				=> 'Options d’affichage et de tri',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Messages',
	'SORT_TOPIC_TITLE'			=> 'Titre du sujet',
	'SORT_USERNAME'				=> 'Nom d’utilisateur',
	'SPLIT_TOPIC'				=> 'Diviser le sujet',
	'SQL_ERROR_OCCURRED'		=> 'Une erreur SQL est arrivée en chargeant cette page. Contactez l’%sadministrateur du forum%s si ce problème persiste.',
	'STATISTICS'				=> 'Statistiques',
	'START_WATCHING_FORUM'		=> 'Surveiller ce forum',
	'START_WATCHING_TOPIC'		=> 'Surveiller ce sujet',
	'STOP_WATCHING_FORUM'		=> 'Arrêter de surveiller ce forum',
	'STOP_WATCHING_TOPIC'		=> 'Arrêter de surveiller ce sujet',
	'STRING_LIST_MULTI'			=> '%1$s, et %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s et %2$s',
	'SUBFORUM'					=> 'Sous-forum',
	'SUBFORUMS'					=> 'Sous-forums',
	'SUBJECT'					=> 'Sujet',
	'SUBMIT'					=> 'Envoyer',

	'TB'				=> 'To',	// téraoctet
	'TERMS_USE'			=> 'Conditions d’utilisation',
	'TEST_CONNECTION'	=> 'Test de connexion',
	'THE_TEAM'			=> 'L’équipe du forum',
	'TIB'				=> 'Tio',	// tébioctect
	'TIME'				=> 'Date',
	'TIMEOUT_PROCESSING_REQ'			=> 'Délai d’attente de la demande dépassé.',

	'TOO_LARGE'						=> 'La valeur saisie est trop grande.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'La valeur du réglage <strong>Nombre maximum autorisé de destinataires par message privé</strong> que vous avez saisie est trop grande.',

	'TOO_LONG'						=> 'La valeur saisie est trop longue.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Le code de confirmation indiqué est trop long.',
	'TOO_LONG_DATEFORMAT'			=> 'Le format de la date indiquée est trop long.',
	'TOO_LONG_JABBER'				=> 'Le nom de compte Jabber indiqué est trop long.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Le mot de passe indiqué est trop long.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Le mot de passe de confirmation indiqué est trop long.',
	'TOO_LONG_USER_PASSWORD'		=> 'Le mot de passe indiqué est trop long.',
	'TOO_LONG_USERNAME'				=> 'Le nom d’utilisateur indiqué est trop long.',
	'TOO_LONG_EMAIL'				=> 'L’adresse courriel indiquée est trop longue.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Vous avez sélectionné trop d’options de vote.',

	'TOO_SHORT'						=> 'La valeur saisie est trop courte.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Le code de confirmation indiqué est trop court.',
	'TOO_SHORT_DATEFORMAT'			=> 'Le format de la date indiquée est trop courte.',
	'TOO_SHORT_JABBER'				=> 'Le nom de compte Jabber indiqué est trop court.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Le mot de passe indiqué est trop court.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Le mot de passe de confirmation indiqué est trop court.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Le mot de passe indiqué est trop court.',
	'TOO_SHORT_USERNAME'			=> 'Le nom d’utilisateur indiqué est trop court.',
	'TOO_SHORT_EMAIL'				=> 'L’adresse courriel indiquée est trop courte.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'L’adresse courriel de confirmation indiquée est trop courte.',
	'TOO_SMALL'						=> 'La valeur saisie est trop petite.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'La valeur du réglage <strong>Nombre maximum autorisé de destinataires par message privé</strong> que vous avez saisie est trop petite.',

	'TOPIC'				=> 'Sujet',
	'TOPICS'			=> 'Sujets',
	'TOPICS_UNAPPROVED'	=> 'Au moins un sujet dans ce forum n’est pas approuvé.',
	'TOPIC_ICON'		=> 'Icône de sujet',
	'TOPIC_LOCKED'		=> 'Ce sujet est verrouillé, vous ne pouvez pas modifier de messages ou poster de réponse.',
	'TOPIC_LOCKED_SHORT'=> 'Sujet verrouillé',
	'TOPIC_MOVED'		=> 'Sujet déplacé',
	'TOPIC_REVIEW'		=> 'Revue du sujet',
	'TOPIC_TITLE'		=> 'Titre du sujet',
	'TOPIC_UNAPPROVED'	=> 'Ce sujet n’a pas été approuvé.',
	'TOPIC_DELETED'		=> 'Ce sujet a été supprimé.',
	'TOTAL_ATTACHMENTS'	=> 'Fichier(s) joint(s)',
	'TOTAL_LOGS'		=> array(
		1	=> '%d entrée',
		2	=> '%d entrées',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d message privé',
		2	=> '%d messages privés',
	),
	'TOPIC_POLL'		=> 'Ce sujet a un sondage.',
	'TOTAL_POSTS'		=> 'Messages',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> '<strong>%d</strong> messages',
	),
	'TOPIC_REPORTED'	=> 'Ce sujet a été rapporté',
	'TOTAL_TOPICS'		=> array(
		2	=> '<strong>%d</strong> sujets',
	),
	'TOTAL_USERS'		=> array(
		2	=> '<strong>%d</strong> membres',
	),
	'TRACKED_PHP_ERROR'	=> 'Suivi des erreurs PHP : %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Impossible de déterminer les dimensions de l’image. Vérifiez que l’URL a été correctement saisie.',
	'UNABLE_TO_DELIVER_FILE'=> 'Impossible de transmettre le fichier.',
	'UNKNOWN_BROWSER'		=> 'Navigateur inconnu',
	'UNMARK_ALL'			=> 'Tout décocher',
	'UNREAD_MESSAGES'		=> 'Messages non lus',
	'UNREAD_POST'			=> 'Message non lu',
	'UNREAD_POSTS'			=> 'Messages non lus',
	'UNWATCH_FORUM_CONFIRM'		=> 'Êtes-vous sûr de ne plus vouloir surveiller ce forum ?',
	'UNWATCH_FORUM_DETAILED'	=> 'Êtes-vous sûr de ne plus vouloir surveiller le forum « %s » ?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Êtes-vous sûr de ne plus vouloir surveiller ce sujet ?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Êtes-vous sûr de ne plus vouloir surveiller le sujet « %s » ?',
	'UNWATCHED_FORUMS'			=> 'Vous ne surveillez plus les forums sélectionnés.',
	'UNWATCHED_TOPICS'			=> 'Vous ne surveillez plus les sujets sélectionnés.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Vous ne surveillez plus les entrées sélectionnées.',
	'UPDATE'				=> 'Mise à jour',
	'UPLOAD_IN_PROGRESS'	=> 'Le transfert est en cours.',
	'URL_REDIRECT'			=> 'Si votre navigateur ne vous redirige pas automatiquement dans quelques instants, %scliquez ici pour être redirigé%s.',
	'USERGROUPS'			=> 'Groupes d’utilisateurs',
	'USERNAME'				=> 'Nom d’utilisateur',
	'USERNAMES'				=> 'Noms d’utilisateur',
	'USER_AVATAR'			=> 'Avatar du membre',
	'USER_CANNOT_READ'		=> 'Vous ne pouvez pas lire les messages de ce forum.',
	'USER_POSTS'			=> array(
		1	=> '%d Message',
		2	=> '%d Messages',
	),
	'USERS'					=> 'Membres',
	'USE_PERMISSIONS'		=> 'Tester les permissions du membre',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Nous sommes désolés, mais vous n’êtes pas autorisé à utiliser cette fonctionnalité. Vous venez juste de vous enregistrer, et il est nécessaire de participer davantage aux discussions pour utiliser cette fonctionnalité.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Vu',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Pas encore vu',
		1	=> 'Vu %d fois',
		2	=> 'Vu %d fois',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Consulte la page de contact',
	'VIEWING_FAQ'				=> 'Consulte la FAQ',
	'VIEWING_MEMBERS'			=> 'Consulte les informations d’un membre',
	'VIEWING_ONLINE'			=> 'Regarde qui est en ligne',
	'VIEWING_MCP'				=> 'Consulte le panneau de modération',
	'VIEWING_MEMBER_PROFILE'	=> 'Consulte le profil d’un membre',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Lit ses messages privés',
	'VIEWING_REGISTER'			=> 'S’enregistre',
	'VIEWING_UCP'				=> 'Consulte son panneau de l’utilisateur',
	'VIEWS'						=> 'Vues',
	'VIEW_BOOKMARKS'			=> 'Afficher les favoris',
	'VIEW_FORUM_LOGS'			=> 'Afficher le journal',
	'VIEW_LATEST_POST'			=> 'Voir le dernier message',
	'VIEW_NEWEST_POST'			=> 'Voir le premier message non lu',
	'VIEW_NOTES'				=> 'Notes sur le membre',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'd’après le nombre d’utilisateurs actifs cette dernière minute',
		2	=> 'd’après le nombre d’utilisateurs actifs ces %d dernières minutes',
	),
	'VIEW_TOPIC'				=> 'Afficher le sujet',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Annonce : ',
	'VIEW_TOPIC_GLOBAL'			=> 'Annonce globale : ',
	'VIEW_TOPIC_LOCKED'			=> 'Verrouillé : ',
	'VIEW_TOPIC_LOGS'			=> 'Voir les journaux',
	'VIEW_TOPIC_MOVED'			=> 'Déplacé : ',
	'VIEW_TOPIC_POLL'			=> 'Sondage : ',
	'VIEW_TOPIC_STICKY'			=> 'Sujet épinglé : ',
	'VISIT_WEBSITE'				=> 'Visiter le site Internet',

	'WARNINGS'			=> 'Avertissements',
	'WARN_USER'			=> 'Avertir le membre',
	'WATCH_FORUM_CONFIRM'	=> 'Êtes-vous sûr de vouloir surveiller ce forum ?',
	'WATCH_FORUM_DETAILED'	=> 'Êtes-vous sûr de vouloir surveiller le forum « %s » ?',
	'WATCH_TOPIC_CONFIRM'	=> 'Êtes-vous sûr de vouloir surveiller ce sujet ?',
	'WATCH_TOPIC_DETAILED'	=> 'Êtes-vous sûr de vouloir surveiller le sujet « %s » ?',
	'WELCOME_SUBJECT'	=> 'Bienvenue sur les forums %s',
	'WEBSITE'			=> 'Site Internet',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Qui est en ligne',
	'WRONG_PASSWORD'	=> 'Vous avez saisi un mot de passe incorrect.',

	'WRONG_DATA_COLOUR'			=> 'La valeur saisie pour la couleur n’est pas valide.',
	'WRONG_DATA_JABBER'			=> 'Le nom que vous avez saisi n’est pas un nom de compte Jabber valide.',
	'WRONG_DATA_LANG'			=> 'La langue que vous avez indiquée n’est pas valide.',
	'WRONG_DATA_POST_SD'		=> 'Le sens du tri de messages que vous avez sélectionné n’est pas valide.',
	'WRONG_DATA_POST_SK'		=> 'L’option de tri de messages que vous avez sélectionnée n’est pas valide.',
	'WRONG_DATA_TOPIC_SD'		=> 'Le sens du tri de sujets que vous avez sélectionné n’est pas valide.',
	'WRONG_DATA_TOPIC_SK'		=> 'L’option de tri de sujets que vous avez sélectionnée n’est pas valide.',
	'WROTE'						=> 'a écrit',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Année',
	'YEAR_MONTH_DAY'	=> '(AAAA-MM-JJ)',
	'YES'				=> 'Oui',
	'YOU_LAST_VISIT'	=> 'Dernière visite : %s',

	'datetime'			=> array(
		'TODAY'		=> 'Aujourd’hui',
		'TOMORROW'	=> 'Demain',
		'YESTERDAY'	=> 'Hier',
		'AGO'		=> array(
			0		=> 'il y a moins d’une minute',
			1		=> 'il y a %d minute',
			2		=> 'il y a %d minutes',
		),

		'Sunday'	=> 'dimanche',
		'Monday'	=> 'lundi',
		'Tuesday'	=> 'mardi',
		'Wednesday'	=> 'mercredi',
		'Thursday'	=> 'jeudi',
		'Friday'	=> 'vendredi',
		'Saturday'	=> 'samedi',

		'Sun'		=> 'dim.',
		'Mon'		=> 'lun.',
		'Tue'		=> 'mar.',
		'Wed'		=> 'mer.',
		'Thu'		=> 'jeu.',
		'Fri'		=> 'ven.',
		'Sat'		=> 'sam.',

		'January'	=> 'janvier',
		'February'	=> 'février',
		'March'		=> 'mars',
		'April'		=> 'avril',
		'May'		=> 'mai',
		'June'		=> 'juin',
		'July'		=> 'juillet',
		'August'	=> 'août',
		'September' => 'septembre',
		'October'	=> 'octobre',
		'November'	=> 'novembre',
		'December'	=> 'décembre',

		'Jan'		=> 'janv.',
		'Feb'		=> 'févr.',
		'Mar'		=> 'mars',
		'Apr'		=> 'avr.',
		'May_short'	=> 'mai',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'juin',
		'Jul'		=> 'juil.',
		'Aug'		=> 'août',
		'Sep'		=> 'sept.',
		'Oct'		=> 'oct.',
		'Nov'		=> 'nov.',
		'Dec'		=> 'déc.',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'		=> 'Afrique/Abidjan',
		'Africa/Accra'			=> 'Afrique/Accra',
		'Africa/Addis_Ababa'	=> 'Afrique/Addis Ababa',
		'Africa/Algiers'		=> 'Afrique/Alger',
		'Africa/Asmara'			=> 'Afrique/Asmara',
		'Africa/Bamako'			=> 'Afrique/Bamako',
		'Africa/Bangui'			=> 'Afrique/Bangui',
		'Africa/Banjul'			=> 'Afrique/Banjul',
		'Africa/Bissau'			=> 'Afrique/Bissau',
		'Africa/Blantyre'		=> 'Afrique/Blantyre',
		'Africa/Brazzaville'	=> 'Afrique/Brazzaville',
		'Africa/Bujumbura'		=> 'Afrique/Bujumbura',
		'Africa/Cairo'			=> 'Afrique/Le Caire',
		'Africa/Casablanca'		=> 'Afrique/Casablanca',
		'Africa/Ceuta'			=> 'Afrique/Ceuta',
		'Africa/Conakry'		=> 'Afrique/Conakry',
		'Africa/Dakar'			=> 'Afrique/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Afrique/Dar es Salaam',
		'Africa/Djibouti'		=> 'Afrique/Djibouti',
		'Africa/Douala'			=> 'Afrique/Douala',
		'Africa/El_Aaiun'		=> 'Afrique/El Aaiun',
		'Africa/Freetown'		=> 'Afrique/Freetown',
		'Africa/Gaborone'		=> 'Afrique/Gaborone',
		'Africa/Harare'			=> 'Afrique/Harare',
		'Africa/Johannesburg'	=> 'Afrique/Johannesburg',
		'Africa/Juba'			=> 'Afrique/Juba',
		'Africa/Kampala'		=> 'Afrique/Kampala',
		'Africa/Khartoum'		=> 'Afrique/Khartoum',
		'Africa/Kigali'			=> 'Afrique/Kigali',
		'Africa/Kinshasa'		=> 'Afrique/Kinshasa',
		'Africa/Lagos'			=> 'Afrique/Lagos',
		'Africa/Libreville'		=> 'Afrique/Libreville',
		'Africa/Lome'			=> 'Afrique/Lome',
		'Africa/Luanda'			=> 'Afrique/Luanda',
		'Africa/Lubumbashi'		=> 'Afrique/Lubumbashi',
		'Africa/Lusaka'			=> 'Afrique/Lusaka',
		'Africa/Malabo'			=> 'Afrique/Malabo',
		'Africa/Maputo'			=> 'Afrique/Maputo',
		'Africa/Maseru'			=> 'Afrique/Maseru',
		'Africa/Mbabane'		=> 'Afrique/Mbabane',
		'Africa/Mogadishu'		=> 'Afrique/Mogadishu',
		'Africa/Monrovia'		=> 'Afrique/Monrovia',
		'Africa/Nairobi'		=> 'Afrique/Nairobi',
		'Africa/Ndjamena'		=> 'Afrique/Ndjamena',
		'Africa/Niamey'			=> 'Afrique/Niamey',
		'Africa/Nouakchott'		=> 'Afrique/Nouakchott',
		'Africa/Ouagadougou'	=> 'Afrique/Ouagadougou',
		'Africa/Porto-Novo'		=> 'Afrique/Porto-Novo',
		'Africa/Sao_Tome'		=> 'Afrique/Sao Tome',
		'Africa/Tripoli'		=> 'Afrique/Tripoli',
		'Africa/Tunis'			=> 'Afrique/Tunis',
		'Africa/Windhoek'		=> 'Afrique/Windhoek',

		'America/Adak'		=> 'Amérique/Adak',
		'America/Anchorage'	=> 'Amérique/Anchorage',
		'America/Anguilla'	=> 'Amérique/Anguilla',
		'America/Antigua'	=> 'Amérique/Antigua',
		'America/Araguaina'	=> 'Amérique/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'Amérique/Argentine/Buenos Aires',
		'America/Argentina/Catamarca'		=> 'Amérique/Argentine/Catamarca',
		'America/Argentina/Cordoba'			=> 'Amérique/Argentine/Cordoba',
		'America/Argentina/Jujuy'			=> 'Amérique/Argentine/Jujuy',
		'America/Argentina/La_Rioja'		=> 'Amérique/Argentine/La Rioja',
		'America/Argentina/Mendoza'			=> 'Amérique/Argentine/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'Amérique/Argentine/Rio Gallegos',
		'America/Argentina/Salta'			=> 'Amérique/Argentine/Salta',
		'America/Argentina/San_Juan'		=> 'Amérique/Argentine/San Juan',
		'America/Argentina/San_Luis'		=> 'Amérique/Argentine/San Luis',
		'America/Argentina/Tucuman'			=> 'Amérique/Argentine/Tucuman',
		'America/Argentina/Ushuaia'			=> 'Amérique/Argentine/Ushuaia',

		'America/Aruba'			=> 'Amérique/Aruba',
		'America/Asuncion'		=> 'Amérique/Asunción',
		'America/Atikokan'		=> 'Amérique/Atikokan',
		'America/Bahia'			=> 'Amérique/Bahia',
		'America/Bahia_Banderas'	=> 'Amérique/Bahia Banderas',
		'America/Barbados'		=> 'Amérique/Barbados',
		'America/Belem'			=> 'Amérique/Belem',
		'America/Belize'		=> 'Amérique/Belize',
		'America/Blanc-Sablon'	=> 'Amérique/Blanc-Sablon',
		'America/Boa_Vista'		=> 'Amérique/Boa Vista',
		'America/Bogota'		=> 'Amérique/Bogota',
		'America/Boise'			=> 'Amérique/Boise',
		'America/Cambridge_Bay'	=> 'Amérique/Cambridge Bay',
		'America/Campo_Grande'	=> 'Amérique/Campo Grande',
		'America/Cancun'		=> 'Amérique/Cancun',
		'America/Caracas'		=> 'Amérique/Caracas',
		'America/Cayenne'		=> 'Amérique/Cayenne',
		'America/Cayman'		=> 'Amérique/Cayman',
		'America/Chicago'		=> 'Amérique/Chicago',
		'America/Chihuahua'		=> 'Amérique/Chihuahua',
		'America/Costa_Rica'	=> 'Amérique/Costa Rica',
		'America/Creston'		=> 'Amérique/Creston',
		'America/Cuiaba'		=> 'Amérique/Cuiaba',
		'America/Curacao'		=> 'Amérique/Curacao',
		'America/Danmarkshavn'	=> 'Amérique/Danmarkshavn',
		'America/Dawson'		=> 'Amérique/Dawson',
		'America/Dawson_Creek'	=> 'Amérique/Dawson Creek',
		'America/Denver'		=> 'Amérique/Denver',
		'America/Detroit'		=> 'Amérique/Detroit',
		'America/Dominica'		=> 'Amérique/Dominica',
		'America/Edmonton'		=> 'Amérique/Edmonton',
		'America/Eirunepe'		=> 'Amérique/Eirunepe',
		'America/El_Salvador'	=> 'Amérique/El Salvador',
		'America/Fortaleza'		=> 'Amérique/Fortaleza',
		'America/Glace_Bay'		=> 'Amérique/Glace Bay',
		'America/Godthab'		=> 'Amérique/Godthab',
		'America/Goose_Bay'		=> 'Amérique/Goose Bay',
		'America/Grand_Turk'	=> 'Amérique/Grand Turk',
		'America/Grenada'		=> 'Amérique/Grenada',
		'America/Guadeloupe'	=> 'Amérique/Guadeloupe',
		'America/Guatemala'		=> 'Amérique/Guatemala',
		'America/Guayaquil'		=> 'Amérique/Guayaquil',
		'America/Guyana'		=> 'Amérique/Guyana',
		'America/Halifax'		=> 'Amérique/Halifax',
		'America/Havana'		=> 'Amérique/Havana',
		'America/Hermosillo'			=> 'Amérique/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'Amérique/Indiana/Indianapolis',
		'America/Indiana/Knox'			=> 'Amérique/Indiana/Knox',
		'America/Indiana/Marengo'		=> 'Amérique/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'Amérique/Indiana/Petersburg',
		'America/Indiana/Tell_City'		=> 'Amérique/Indiana/Tell City',
		'America/Indiana/Vevay'			=> 'Amérique/Indiana/Vevay',
		'America/Indiana/Vincennes'		=> 'Amérique/Indiana/Vincennes',
		'America/Indiana/Winamac'		=> 'Amérique/Indiana/Winamac',
		'America/Inuvik'		=> 'Amérique/Inuvik',
		'America/Iqaluit'		=> 'Amérique/Iqaluit',
		'America/Jamaica'		=> 'Amérique/Jamaïque',
		'America/Juneau'		=> 'Amérique/Juneau',
		'America/Kentucky/Louisville'	=> 'Amérique/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'Amérique/Kentucky/Monticello',
		'America/Kralendijk'	=> 'Amérique/Kralendijk',
		'America/La_Paz'		=> 'Amérique/La Paz',
		'America/Lima'			=> 'Amérique/Lima',
		'America/Los_Angeles'	=> 'Amérique/Los Angeles',
		'America/Lower_Princes'	=> 'Amérique/Lower Princes',
		'America/Maceio'		=> 'Amérique/Maceio',
		'America/Managua'		=> 'Amérique/Managua',
		'America/Manaus'		=> 'Amérique/Manaus',
		'America/Marigot'		=> 'Amérique/Marigot',
		'America/Martinique'	=> 'Amérique/Martinique',
		'America/Matamoros'		=> 'Amérique/Matamoros',
		'America/Mazatlan'		=> 'Amérique/Mazatlan',
		'America/Menominee'		=> 'Amérique/Menominee',
		'America/Merida'		=> 'Amérique/Mérida',
		'America/Metlakatla'	=> 'Amérique/Metlakatla',
		'America/Mexico_City'	=> 'Amérique/Mexico City',
		'America/Miquelon'		=> 'Amérique/Miquelon',
		'America/Moncton'		=> 'Amérique/Moncton',
		'America/Monterrey'		=> 'Amérique/Monterrey',
		'America/Montevideo'	=> 'Amérique/Montévidéo',
		'America/Montreal'		=> 'Amérique/Montréal',
		'America/Montserrat'	=> 'Amérique/Montserrat',
		'America/Nassau'		=> 'Amérique/Nassau',
		'America/New_York'		=> 'Amérique/New York',
		'America/Nipigon'		=> 'Amérique/Nipigon',
		'America/Nome'			=> 'Amérique/Nome',
		'America/Noronha'		=> 'Amérique/Noronha',
		'America/North_Dakota/Beulah'		=> 'Amérique/Dakota du Nord/Beulah',
		'America/North_Dakota/Center'		=> 'Amérique/Dakota du Nord/Center',
		'America/North_Dakota/New_Salem'	=> 'Amérique/Dakota du Nord/New Salem',
		'America/Ojinaga'		=> 'Amérique/Ojinaga',
		'America/Panama'		=> 'Amérique/Panama',
		'America/Pangnirtung'	=> 'Amérique/Pangnirtung',
		'America/Paramaribo'	=> 'Amérique/Paramaribo',
		'America/Phoenix'		=> 'Amérique/Phoenix',
		'America/Port-au-Prince'	=> 'Amérique/Port-au-Prince',
		'America/Port_of_Spain'	=> 'Amérique/Port of Spain',
		'America/Porto_Velho'	=> 'Amérique/Porto Velho',
		'America/Puerto_Rico'	=> 'Amérique/Puerto Rico',
		'America/Rainy_River'	=> 'Amérique/Rainy River',
		'America/Rankin_Inlet'	=> 'Amérique/Rankin Inlet',
		'America/Recife'		=> 'Amérique/Recife',
		'America/Regina'		=> 'Amérique/Regina',
		'America/Resolute'		=> 'Amérique/Resolute',
		'America/Rio_Branco'	=> 'Amérique/Rio Branco',
		'America/Santa_Isabel'	=> 'Amérique/Santa Isabel',
		'America/Santarem'		=> 'Amérique/Santarem',
		'America/Santiago'		=> 'Amérique/Santiago',
		'America/Santo_Domingo'	=> 'Amérique/Santo Domingo',
		'America/Sao_Paulo'		=> 'Amérique/Sao Paulo',
		'America/Scoresbysund'	=> 'Amérique/Scoresbysund',
		'America/Shiprock'		=> 'Amérique/Shiprock',
		'America/Sitka'			=> 'Amérique/Sitka',
		'America/St_Barthelemy'	=> 'Amérique/St. Barthelemy',
		'America/St_Johns'		=> 'Amérique/St. Johns',
		'America/St_Kitts'		=> 'Amérique/St. Kitts',
		'America/St_Lucia'		=> 'Amérique/St. Lucia',
		'America/St_Thomas'		=> 'Amérique/St. Thomas',
		'America/St_Vincent'	=> 'Amérique/St. Vincent',
		'America/Swift_Current'	=> 'Amérique/Swift Current',
		'America/Tegucigalpa'	=> 'Amérique/Tegucigalpa',
		'America/Thule'			=> 'Amérique/Thule',
		'America/Thunder_Bay'	=> 'Amérique/Thunder Bay',
		'America/Tijuana'		=> 'Amérique/Tijuana',
		'America/Toronto'		=> 'Amérique/Toronto',
		'America/Tortola'		=> 'Amérique/Tortola',
		'America/Vancouver'		=> 'Amérique/Vancouver',
		'America/Whitehorse'	=> 'Amérique/Whitehorse',
		'America/Winnipeg'		=> 'Amérique/Winnipeg',
		'America/Yakutat'		=> 'Amérique/Yakutat',
		'America/Yellowknife'	=> 'Amérique/Yellowknife',

		'Antarctica/Casey'			=> 'Antarctique/Casey',
		'Antarctica/Davis'			=> 'Antarctique/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarctique/DumontDUrville',
		'Antarctica/Macquarie'		=> 'Antarctique/Macquarie',
		'Antarctica/Mawson'			=> 'Antarctique/Mawson',
		'Antarctica/McMurdo'		=> 'Antarctique/McMurdo',
		'Antarctica/Palmer'			=> 'Antarctique/Palmer',
		'Antarctica/Rothera'		=> 'Antarctique/Rothera',
		'Antarctica/South_Pole'		=> 'Antarctique/South Pole',
		'Antarctica/Syowa'			=> 'Antarctique/Syowa',
		'Antarctica/Vostok'			=> 'Antarctique/Vostok',

		'Arctic/Longyearbyen'	=> 'Arctique/Longyearbyen',

		'Asia/Aden'			=> 'Asie/Aden',
		'Asia/Almaty'		=> 'Asie/Almaty',
		'Asia/Amman'		=> 'Asie/Amman',
		'Asia/Anadyr'		=> 'Asie/Anadyr',
		'Asia/Aqtau'		=> 'Asie/Aqtau',
		'Asia/Aqtobe'		=> 'Asie/Aqtobe',
		'Asia/Ashgabat'		=> 'Asie/Ashgabat',
		'Asia/Baghdad'		=> 'Asie/Baghdad',
		'Asia/Bahrain'		=> 'Asie/Bahrain',
		'Asia/Baku'			=> 'Asie/Baku',
		'Asia/Bangkok'		=> 'Asie/Bangkok',
		'Asia/Beirut'		=> 'Asie/Beirut',
		'Asia/Bishkek'		=> 'Asie/Bishkek',
		'Asia/Brunei'		=> 'Asie/Brunei',
		'Asia/Choibalsan'	=> 'Asie/Choibalsan',
		'Asia/Chongqing'	=> 'Asie/Chongqing',
		'Asia/Colombo'		=> 'Asie/Colombo',
		'Asia/Damascus'		=> 'Asie/Damascus',
		'Asia/Dhaka'		=> 'Asie/Dhaka',
		'Asia/Dili'			=> 'Asie/Dili',
		'Asia/Dubai'		=> 'Asie/Dubaï',
		'Asia/Dushanbe'		=> 'Asie/Dushanbe',
		'Asia/Gaza'			=> 'Asie/Gaza',
		'Asia/Harbin'		=> 'Asie/Harbin',
		'Asia/Hebron'		=> 'Asie/Hébron',
		'Asia/Ho_Chi_Minh'	=> 'Asie/Ho Chi Minh',
		'Asia/Hong_Kong'	=> 'Asie/Hong Kong',
		'Asia/Hovd'			=> 'Asie/Hovd',
		'Asia/Irkutsk'		=> 'Asie/Irkutsk',
		'Asia/Jakarta'		=> 'Asie/Jakarta',
		'Asia/Jayapura'		=> 'Asie/Jayapura',
		'Asia/Jerusalem'	=> 'Asie/Jérusalem',
		'Asia/Kabul'		=> 'Asie/Kabul',
		'Asia/Kamchatka'	=> 'Asie/Kamchatka',
		'Asia/Karachi'		=> 'Asie/Karachi',
		'Asia/Kashgar'		=> 'Asie/Kashgar',
		'Asia/Kathmandu'	=> 'Asie/Kathmandu',
		'Asia/Khandyga'		=> 'Asie/Khandyga',
		'Asia/Kolkata'		=> 'Asie/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Asie/Krasnoyarsk',
		'Asia/Kuala_Lumpur'	=> 'Asie/Kuala Lumpur',
		'Asia/Kuching'		=> 'Asie/Kuching',
		'Asia/Kuwait'		=> 'Asie/Kuwait',
		'Asia/Macau'		=> 'Asie/Macau',
		'Asia/Magadan'		=> 'Asie/Magadan',
		'Asia/Makassar'		=> 'Asie/Makassar',
		'Asia/Manila'		=> 'Asie/Manille',
		'Asia/Muscat'		=> 'Asie/Muscat',
		'Asia/Nicosia'		=> 'Asie/Nicosia',
		'Asia/Novokuznetsk'	=> 'Asie/Novokuznetsk',
		'Asia/Novosibirsk'	=> 'Asie/Novosibirsk',
		'Asia/Omsk'			=> 'Asie/Omsk',
		'Asia/Oral'			=> 'Asie/Oral',
		'Asia/Phnom_Penh'	=> 'Asie/Phnom Penh',
		'Asia/Pontianak'	=> 'Asie/Pontianak',
		'Asia/Pyongyang'	=> 'Asie/Pyongyang',
		'Asia/Qatar'		=> 'Asie/Qatar',
		'Asia/Qyzylorda'	=> 'Asie/Qyzylorda',
		'Asia/Rangoon'		=> 'Asie/Rangoon',
		'Asia/Riyadh'		=> 'Asie/Riyadh',
		'Asia/Sakhalin'		=> 'Asie/Sakhalin',
		'Asia/Samarkand'	=> 'Asie/Samarkand',
		'Asia/Seoul'		=> 'Asie/Seoul',
		'Asia/Shanghai'		=> 'Asie/Shanghai',
		'Asia/Singapore'	=> 'Asie/Singapore',
		'Asia/Taipei'		=> 'Asie/Taipei',
		'Asia/Tashkent'		=> 'Asie/Tashkent',
		'Asia/Tbilisi'		=> 'Asie/Tbilisi',
		'Asia/Tehran'		=> 'Asie/Tehran',
		'Asia/Thimphu'		=> 'Asie/Thimphu',
		'Asia/Tokyo'		=> 'Asie/Tokyo',
		'Asia/Ulaanbaatar'	=> 'Asie/Ulaanbaatar',
		'Asia/Urumqi'		=> 'Asie/Urumqi',
		'Asia/Ust-Nera'		=> 'Asie/Ust-Nera',
		'Asia/Vientiane'	=> 'Asie/Vientiane',
		'Asia/Vladivostok'	=> 'Asie/Vladivostok',
		'Asia/Yakutsk'		=> 'Asie/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Asie/Yekaterinburg',
		'Asia/Yerevan'		=> 'Asie/Yerevan',

		'Atlantic/Azores'		=> 'Atlantique/Açores',
		'Atlantic/Bermuda'		=> 'Atlantique/Bermudes',
		'Atlantic/Canary'		=> 'Atlantique/Canaries',
		'Atlantic/Cape_Verde'	=> 'Atlantique/Cap Vert',
		'Atlantic/Faroe'		=> 'Atlantique/Féroé',
		'Atlantic/Madeira'		=> 'Atlantique/Madère',
		'Atlantic/Reykjavik'	=> 'Atlantique/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlantique/South Georgia',
		'Atlantic/St_Helena'	=> 'Atlantique/St. Hélène',
		'Atlantic/Stanley'		=> 'Atlantique/Stanley',

		'Australia/Adelaide'	=> 'Australie/Adélaïde',
		'Australia/Brisbane'	=> 'Australie/Brisbane',
		'Australia/Broken_Hill'	=> 'Australie/Broken Hill',
		'Australia/Currie'		=> 'Australie/Currie',
		'Australia/Darwin'		=> 'Australie/Darwin',
		'Australia/Eucla'		=> 'Australie/Eucla',
		'Australia/Hobart'		=> 'Australie/Hobart',
		'Australia/Lindeman'	=> 'Australie/Lindeman',
		'Australia/Lord_Howe'	=> 'Australie/Lord Howe',
		'Australia/Melbourne'	=> 'Australie/Melbourne',
		'Australia/Perth'		=> 'Australie/Perth',
		'Australia/Sydney'		=> 'Australie/Sydney',

		'Europe/Amsterdam'	=> 'Europe/Amsterdam',
		'Europe/Andorra'	=> 'Europe/Andorre',
		'Europe/Athens'		=> 'Europe/Athènes',
		'Europe/Belgrade'	=> 'Europe/Belgrade',
		'Europe/Berlin'		=> 'Europe/Berlin',
		'Europe/Bratislava'	=> 'Europe/Bratislava',
		'Europe/Brussels'	=> 'Europe/Bruxelles',
		'Europe/Bucharest'	=> 'Europe/Bucharest',
		'Europe/Budapest'	=> 'Europe/Budapest',
		'Europe/Busingen'	=> 'Europe/Busingen',
		'Europe/Chisinau'	=> 'Europe/Chisinau',
		'Europe/Copenhagen'	=> 'Europe/Copenhage',
		'Europe/Dublin'		=> 'Europe/Dublin',
		'Europe/Gibraltar'	=> 'Europe/Gibraltar',
		'Europe/Guernsey'	=> 'Europe/Guernesey',
		'Europe/Helsinki'	=> 'Europe/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europe/Île de Man',
		'Europe/Istanbul'	=> 'Europe/Istanbul',
		'Europe/Jersey'		=> 'Europe/Jersey',
		'Europe/Kaliningrad'	=> 'Europe/Kaliningrad',
		'Europe/Kiev'		=> 'Europe/Kiev',
		'Europe/Lisbon'		=> 'Europe/Lisbonne',
		'Europe/Ljubljana'	=> 'Europe/Ljubljana',
		'Europe/London'		=> 'Europe/Londres',
		'Europe/Luxembourg'	=> 'Europe/Luxembourg',
		'Europe/Madrid'		=> 'Europe/Madrid',
		'Europe/Malta'		=> 'Europe/Malte',
		'Europe/Mariehamn'	=> 'Europe/Mariehamn',
		'Europe/Minsk'		=> 'Europe/Minsk',
		'Europe/Monaco'		=> 'Europe/Monaco',
		'Europe/Moscow'		=> 'Europe/Moscou',
		'Europe/Oslo'		=> 'Europe/Oslo',
		'Europe/Paris'		=> 'Europe/Paris',
		'Europe/Podgorica'	=> 'Europe/Podgorica',
		'Europe/Prague'		=> 'Europe/Prague',
		'Europe/Riga'		=> 'Europe/Riga',
		'Europe/Rome'		=> 'Europe/Rome',
		'Europe/Samara'		=> 'Europe/Samara',
		'Europe/San_Marino'	=> 'Europe/San Marino',
		'Europe/Sarajevo'	=> 'Europe/Sarajevo',
		'Europe/Simferopol'	=> 'Europe/Simferopol',
		'Europe/Skopje'		=> 'Europe/Skopje',
		'Europe/Sofia'		=> 'Europe/Sofia',
		'Europe/Stockholm'	=> 'Europe/Stockholm',
		'Europe/Tallinn'	=> 'Europe/Tallinn',
		'Europe/Tirane'		=> 'Europe/Tirane',
		'Europe/Uzhgorod'	=> 'Europe/Uzhgorod',
		'Europe/Vaduz'		=> 'Europe/Vaduz',
		'Europe/Vatican'	=> 'Europe/Vatican',
		'Europe/Vienna'		=> 'Europe/Vienne',
		'Europe/Vilnius'	=> 'Europe/Vilnius',
		'Europe/Volgograd'	=> 'Europe/Volgograd',
		'Europe/Warsaw'		=> 'Europe/Warsaw',
		'Europe/Zagreb'		=> 'Europe/Zagreb',
		'Europe/Zaporozhye'	=> 'Europe/Zaporozhye',
		'Europe/Zurich'		=> 'Europe/Zurich',

		'Indian/Antananarivo'	=> 'Océan Indien/Antananarivo',
		'Indian/Chagos'		=> 'Océan Indien/Chagos',
		'Indian/Christmas'	=> 'Océan Indien/Christmas',
		'Indian/Cocos'		=> 'Océan Indien/Cocos',
		'Indian/Comoro'		=> 'Océan Indien/Comoro',
		'Indian/Kerguelen'	=> 'Océan Indien/Kerguélen',
		'Indian/Mahe'		=> 'Océan Indien/Mahe',
		'Indian/Maldives'	=> 'Océan Indien/Maldives',
		'Indian/Mauritius'	=> 'Océan Indien/Maurice',
		'Indian/Mayotte'	=> 'Océan Indien/Mayotte',
		'Indian/Reunion'	=> 'Océan Indien/Réunion',

		'Pacific/Apia'		=> 'Pacifique/Apia',
		'Pacific/Auckland'	=> 'Pacifique/Auckland',
		'Pacific/Chatham'	=> 'Pacifique/Chatham',
		'Pacific/Chuuk'		=> 'Pacifique/Chuuk',
		'Pacific/Easter'	=> 'Pacifique/Easter',
		'Pacific/Efate'		=> 'Pacifique/Efate',
		'Pacific/Enderbury'	=> 'Pacifique/Enderbury',
		'Pacific/Fakaofo'	=> 'Pacifique/Fakaofo',
		'Pacific/Fiji'		=> 'Pacifique/Fiji',
		'Pacific/Funafuti'	=> 'Pacifique/Funafuti',
		'Pacific/Galapagos'	=> 'Pacifique/Galapagos',
		'Pacific/Gambier'	=> 'Pacifique/Gambier',
		'Pacific/Guadalcanal'	=> 'Pacifique/Guadalcanal',
		'Pacific/Guam'		=> 'Pacifique/Guam',
		'Pacific/Honolulu'	=> 'Pacifique/Honolulu',
		'Pacific/Johnston'	=> 'Pacifique/Johnston',
		'Pacific/Kiritimati'	=> 'Pacifique/Kiritimati',
		'Pacific/Kosrae'	=> 'Pacifique/Kosrae',
		'Pacific/Kwajalein'	=> 'Pacifique/Kwajalein',
		'Pacific/Majuro'	=> 'Pacifique/Majuro',
		'Pacific/Marquesas'	=> 'Pacifique/Îles Marquises',
		'Pacific/Midway'	=> 'Pacifique/Midway',
		'Pacific/Nauru'		=> 'Pacifique/Nauru',
		'Pacific/Niue'		=> 'Pacifique/Niue',
		'Pacific/Norfolk'	=> 'Pacifique/Norfolk',
		'Pacific/Noumea'	=> 'Pacifique/Nouméa',
		'Pacific/Pago_Pago'	=> 'Pacifique/Pago Pago',
		'Pacific/Palau'		=> 'Pacifique/Palau',
		'Pacific/Pitcairn'	=> 'Pacifique/Pitcairn',
		'Pacific/Pohnpei'	=> 'Pacifique/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Pacifique/Port Moresby',
		'Pacific/Rarotonga'	=> 'Pacifique/Rarotonga',
		'Pacific/Saipan'	=> 'Pacifique/Saipan',
		'Pacific/Tahiti'	=> 'Pacifique/Tahiti',
		'Pacific/Tarawa'	=> 'Pacifique/Tarawa',
		'Pacific/Tongatapu'	=> 'Pacifique/Tongatapu',
		'Pacific/Wake'		=> 'Pacifique/Wake',
		'Pacific/Wallis'	=> 'Pacifique/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 janv. 2007, 13:37',
		'd M Y H:i'				=> '01 janv. 2007 13:37',
		'M jS, \'y, H:i'		=> 'janv. 1er, \'07, 13:37',
		'D M d, Y g:i a'		=> 'lun janv. 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'janvier 1er, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> '[Jours relatifs], 13:37 / 01 janv. 2007, 13:37',
		'|F jS, Y|, g:i a'		=> '[Jours relatifs], 1:37 pm / janvier 1er, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D j M Y H:i', // lun 10 janv. 2007 13:37

));
