<?php
/** 
*
* ucp [Standard french]
* translated originally by PhpBB-fr.com <http://www.phpbb-fr.com/> and phpBB.biz <http://www.phpBB.biz>
*
* @package language
* @version $Id: ucp.php, v1.26 10:35 14/06/2011 Lolovoisin Exp $
* @copyright (c) 2005 phpBB Group 
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
   $lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT' => 'En accédant à “%1$s” (désigné ici par “nous”, “notre”, “nos”, “%1$s”, “%2$s”), vous acceptez d’être légalement responsable des conditions suivantes. Si vous n’acceptez pas d’être légalement responsable de toutes les conditions suivantes, alors n’accédez pas et/ou n’utilisez pas “%1$s”. Nous pouvons modifier celles-ci à n’importe quel moment et nous ferons tout pour que vous en soyez informé, bien qu’il soit prudent de vérifier régulièrement celles-ci par vous-même. Si vous continuez d’utiliser “%1$s” alors que des changements ont été effectués, vous acceptez d’être légalement responsable des conditions découlant des mises à jour et/ou modifications.<br />
	<br />
	Notre forum est de type phpBB (désigné ici par “ils”, “eux”, “leur”, “logiciel phpBB”, “www.phpbb.com”, “Groupe phpBB”, “Equipes phpBB”) qui est un script libre de forum, déclaré sous la licence “<a href="http://opensource.org/licenses/gpl-license.php">General Public License</a>” (désigné ici par “GPL”) et qui peut être téléchargé depuis <a href="http://www.phpbb.com/">www.phpbb.com</a>. Le logiciel phpBB facilite seulement les discussions basées sur internet. Le groupe phpBB n’est pas responsable de ce que nous acceptons et/ou n’acceptons pas, comme contenu ou conduite permis. Pour de plus amples informations au sujet de phpBB, merci de consulter: <a href="http://www.phpbb.com/">http://www.phpbb.com/</a>.<br />
	<br />
	Vous acceptez de ne pas publier de contenu abusif, obscène, vulgaire, diffamatoire, choquant, menaçant, à caractère sexuel ou autre qui peut transgresser les lois de votre pays, du pays où “%1$s” est hébergé ou les lois internationales. Le faire peut vous mener à un bannissement immédiat et permanent, avec une notification à votre fournisseur d’accès à internet si nous le jugeons nécessaire. L’adresse IP de tous les messages est enregistrée pour aider au renforcement de ces conditions. Vous acceptez que “%1$s” supprime, édite, déplace ou verrouille n’importe quel sujet lorsque nous estimons que cela est nécessaire. En tant qu’utilisateur, vous acceptez que toutes les informations que vous avez entrées soient stockées dans notre base de données. Bien que ces informations ne soient pas diffusées à une tierce partie sans votre consentement, ni “%1$s”, ni phpBB ne pourront être tenus comme responsables en cas de tentative de piratage visant à compromettre les données.
	',
	'PRIVACY_POLICY'      => 'Cette politique explique en détail comment “%1$s” et ses sociétés affiliées (désignés ici par “nous”, “notre”, “nos”, “%1$s”, “%2$s”) et phpBB (désigné ici par “ils”, “eux”, “leur”, “logiciel phpBB”, “www.phpbb.com”, “Groupe phpBB”, “Equipes phpBB”) utilisent n’importe quelle information collectée pendant n’importe quelle session d’utilisation de votre part (désignée ici “vos informations”).<br />
	<br />
	Vos informations sont collectées de deux manières. Premièrement, en naviguant sur “%1$s”, le logiciel phpBB créera un certain nombre de cookies, qui sont des petits fichiers textes téléchargés dans les fichiers temporaires du navigateur internet de votre ordinateur. Les deux premiers cookies ne contiennent qu’un identifiant utilisateur (désigné ici par “ID de l’utilisateur”) et un identifiant de session invité (désigné ici par “ID de la session”), qui vous sont automatiquement assignés par le logiciel phpBB. Un troisième cookie sera créé une fois que vous naviguerez sur les sujets de “%1$s” et est utilisé pour stocker les informations sur les sujets que vous avez lus, ce qui améliore votre navigation sur le forum .<br />
	<br />
	Nous pouvons également créer des cookies externes au logiciel phpBB tout en naviguant sur “%1$s”, bien que ceux-ci soient hors de portée du document qui est prévu pour couvrir seulement les pages créées par le logiciel phpBB. La seconde manière est de récupérer l’information que vous nous envoyez et que nous collectons. Ceci peut être, et n’est pas limité à: la publication en tant qu’utilisateur invité (désignée ici par “messages invités”), l’inscription sur “%1$s” (désignée ici par “votre compte”) et les messages que vous envoyez après l’inscription et lors d’une connexion (désignés ici par “vos messages”).<br />
	<br />
	Votre compte contiendra au minimum un identifiant unique (désigné ici par “votre nom d’utilisateur”), un mot de passe personnel utilisé pour la connexion à votre compte (désigné ici par “votre mot de passe”), et une adresse e-mail personnelle valide (désignée ici par “votre e-mail”). Vos informations pour votre compte sur “%1$s” sont protégées par les lois de protection des données applicables dans le pays qui nous héberge. Toute information en-dehors de votre nom d’utilisateur, de votre mot de passe et de votre adresse e-mail requise par “%1$s” durant la procédure d’inscription, qu’elle soit obligatoire ou non, reste à la discrétion de “%1$s”. Dans tous les cas, vous pouvez choisir quelle information de votre compte sera affichée publiquement. De plus, dans votre profil, vous pouvez souscrire ou non à l’envoi automatique d’e-mail par le logiciel phpBB.<br />
	<br />
	Votre mot de passe est crypté (hashage à sens unique) afin qu’il soit sécurisé. Cependant, il est recommandé de ne pas utiliser le même mot de passe sur plusieurs sites internet différents. Votre mot de passe est le moyen d’accès à votre compte sur “%1$s”, conservez-le soigneusement et en aucun cas une personne affiliée de “%1$s”, de phpBB ou une d’une tierce partie ne peut vous demander légitimement votre mot de passe. Si vous oubliez votre mot de passe, vous pouvez utiliser la fonction “J’ai perdu mon mot de passe” fournie par le logiciel phpBB. Ce processus vous demandera de fournir votre nom d’utilisateur et votre e-mail, alors le logiciel phpBB générera un nouveau mot de passe qui vous permettra de vous reconnecter.<br />
	',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'   				=> 'Votre compte a été activé. Merci de votre inscription.',
	'ACCOUNT_ACTIVE_ADMIN'   		=> 'Le compte a été activé.',
	'ACCOUNT_ACTIVE_PROFILE'   		=> 'Votre compte a été réactivé.',
	'ACCOUNT_ADDED'   				=> 'Merci de votre inscription, votre compte a été créé. Vous pouvez vous connecter en utilisant votre nom d’utilisateur et votre mot de passe.',
	'ACCOUNT_COPPA'   				=> 'Votre compte a été créé mais il doit être activé, consultez vos e-mails pour en savoir plus.',
	'ACCOUNT_EMAIL_CHANGED'   		=> 'Votre compte a été mis à jour. Néanmoins, vous devez le réactiver. Une clef d’activation a été renvoyée à votre nouvelle adresse e-mail. Vérifiez vos e-mails pour plus d’informations.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'   => 'Votre compte a été mis à jour. Néanmoins, les administrateurs du forum doivent réactiver votre compte. Un e-mail leur a été envoyé, vous serez prévenu dès que votre compte sera réactivé.',
	'ACCOUNT_INACTIVE'   			=> 'Votre compte a été créé. Cependant, il doit être activé. Une clé d’activation vous a été envoyée par e-mail. Vérifiez vos e-mails pour plus d’informations.',
	'ACCOUNT_INACTIVE_ADMIN'   		=> 'Votre compte a été créé. Cependant, un administrateur doit le valider. Un courrier lui a été envoyé et vous serez informé de l’activation de votre compte.',
	'ACTIVATION_EMAIL_SENT'   		=> 'Le message d’activation a été envoyé à votre adresse e-mail.',
	'ACTIVATION_EMAIL_SENT_ADMIN'	=> 'Le message d’activation a été envoyé aux adresses e-mail des administrateurs.',
	'ADD'  							=> 'Ajouter',
	'ADD_BCC'   					=> 'Ajout [CCI]',
	'ADD_FOES'   					=> 'Ajouter des ignorés',
	'ADD_FOES_EXPLAIN'   			=> 'Entrez un nom d’utilisateur par ligne',
	'ADD_FOLDER'   					=> 'Nouveau dossier',
	'ADD_FRIENDS'   				=> 'Ajouter des amis',
	'ADD_FRIENDS_EXPLAIN'   		=> 'Entrez un nom d’utilisateur par ligne.',
	'ADD_NEW_RULE'   				=> 'Créer un nouveau filtre de messages',
	'ADD_RULE'   					=> 'Appliquer le filtre',
	'ADD_TO'   						=> 'Ajout [A]',
	'ADD_USERS_UCP_EXPLAIN'			=> 'Vous pouvez ajouter de nouveaux utilisateurs au groupe. Vous pouvez choisir si ce groupe devient le nouveau groupe par défaut pour les utilisateurs sélectionnés. Entrez chaque nom d’utilisateur sur une ligne différente.',
	'ADMIN_EMAIL'   				=> 'Recevoir les e-mails des administrateurs',
	'AGREE'   						=> 'J’accepte ces conditions',
	'ALLOW_PM'   					=> 'Recevoir les messages privés des utilisateurs',
	'ALLOW_PM_EXPLAIN'   			=> 'Notez que les administrateurs et modérateurs peuvent toujours vous envoyer des messages privés.',
	'ALREADY_ACTIVATED'  			=> 'Votre compte a déjà été activé.',
	'ATTACHMENTS_EXPLAIN'   		=> 'Liste des fichiers joints à vos messages dans le forum.',
	'ATTACHMENTS_DELETED'   		=> 'Les fichiers joints ont été supprimés.',
	'ATTACHMENT_DELETED'   			=> 'Le fichier joint a été supprimé.',
	'AVATAR_CATEGORY'   			=> 'Catégorie',
	'AVATAR_EXPLAIN'   				=> 'Dimensions maximales; largeur: %1$d pixels, hauteur: %2$d pixels, taille: %3$.2f Kio.',
	'AVATAR_FEATURES_DISABLED'   	=> 'La fonctionnalité des avatars est actuellement désactivée.',
	'AVATAR_GALLERY'   				=> 'Galerie locale',
	'AVATAR_GENERAL_UPLOAD_ERROR'   => 'Impossible de charger l’avatar vers %s',
	'AVATAR_NOT_ALLOWED'			=> 'Votre avatar ne peut pas être affiché car les avatars sont désactivés.',
	'AVATAR_PAGE'   				=> 'Page',
	'AVATAR_TYPE_NOT_ALLOWED'		=> 'Votre avatar actuel ne peut pas être affiché car ce type d’avatar a été désactivé.',

	'BACK_TO_DRAFTS'   			=> 'Retour aux brouillons',
	'BACK_TO_LOGIN'   			=> 'Retour à l’écran de connexion',
	'BIRTHDAY'   				=> 'Anniversaire',
	'BIRTHDAY_EXPLAIN'   		=> 'Indiquer une année permettra d’afficher votre âge lors de votre anniversaire.',
	'BOARD_DATE_FORMAT'   		=> 'Format de la date',
	'BOARD_DATE_FORMAT_EXPLAIN' => 'La syntaxe utilisée est identique à la fonction PHP <a href="http://www.php.net/date">date()</a>.',
	'BOARD_DST'   				=> 'Heure d’été en vigueur',
	'BOARD_LANGUAGE'   			=> 'Langue',
	'BOARD_STYLE'   			=> 'Style',
	'BOARD_TIMEZONE'   			=> 'Fuseau horaire',
	'BOOKMARKS'   				=> 'Favoris',
	'BOOKMARKS_EXPLAIN'   		=> 'Vous pouvez enregistrer des sujets dans vos favoris pour vous y référer ultérieurement. Utilisez les cases à cocher pour sélectionner des favoris, et choisissez le bouton <em>Supprimer</em>.',
	'BOOKMARKS_DISABLED'   		=> 'Les favoris sont désactivés sur ce forum.',
	'BOOKMARKS_REMOVED'   		=> 'Les favoris ont été supprimés.',

	'CANNOT_EDIT_MESSAGE_TIME'  => 'Vous ne pouvez plus modifier ou supprimer ce message.',
	'CANNOT_MOVE_TO_SAME_FOLDER'=> 'Les messages ne peuvent pas être déplacés dans le dossier que vous souhaitez supprimer.',
	'CANNOT_MOVE_FROM_SPECIAL'	=> 'Les messages ne peuvent pas être déplacés de la boîte d’envoi.',
	'CANNOT_RENAME_FOLDER'   	=> 'Ce dossier ne peut pas être renommé.',
	'CANNOT_REMOVE_FOLDER'   	=> 'Ce dossier ne peut pas être supprimé.',
	'CHANGE_DEFAULT_GROUP'   	=> 'Changer de groupe par défaut',
	'CHANGE_PASSWORD'   		=> 'Changer de mot de passe',
	'CLICK_GOTO_FOLDER'     	=> '%1$s Aller à votre dossier “%3$s” %2$s',
	'CLICK_RETURN_FOLDER'   	=> '%1$s Retour à votre dossier “%3$s” %2$s',
	'CONFIRMATION'   			=> 'Confirmation d’inscription',
	'CONFIRM_CHANGES'   		=> 'Confirmation des modifications',
	'CONFIRM_EMAIL'   			=> 'Confirmation de l’adresse e-mail',
	'CONFIRM_EMAIL_EXPLAIN'   	=> 'Vous devez l’indiquer uniquement en cas de modification de votre adresse e-mail.',
	'CONFIRM_EXPLAIN'   		=> 'Pour éviter les inscriptions automatisées, l’administrateur exige la saisie d’un code de confirmation. Ce code est inscrit dans l’image affichée ci-dessous. Si vous êtes déficient visuel ou si vous ne pouvez pas lire ce code, contactez %sl’administrateur de ce forum%s.',
	'VC_REFRESH'				=> 'Rafraîchir le code de confirmation',
	'VC_REFRESH_EXPLAIN'		=> 'Si vous n’arrivez pas à lire le code, vous pouvez en demander un nouveau en cliquant.',
	'CONFIRM_PASSWORD'   		=> 'Confirmation du mot de passe',
	'CONFIRM_PASSWORD_EXPLAIN'  => 'Vous devez confirmer le mot de passe uniquement si vous l’avez modifié ci-dessus.',
	'COPPA_BIRTHDAY'   			=> 'Pour continuer l’inscription, indiquez votre date de naissance.',
	'COPPA_COMPLIANCE'   		=> 'Certification COPPA',
	'COPPA_EXPLAIN'   			=> 'Notez qu’en cliquant sur valider, votre compte sera créé. Il ne sera cependant activé que si un parent ou tuteur approuve votre inscription. Une copie du formulaire à renvoyer vous a été adressée par e-mail.',
	'CREATE_FOLDER'   			=> 'Nouveau dossier…',
	'CURRENT_IMAGE'   			=> 'Image actuelle',
	'CURRENT_PASSWORD'   		=> 'Mot de passe actuel',
	'CURRENT_PASSWORD_EXPLAIN'  => 'Vous ne devez confirmer votre mot de passe actuel que si vous désirez modifier votre mot de passe, e-mail ou nom d’utilisateur.',
	'CUR_PASSWORD_ERROR'   		=> 'Le mot de passe actuel indiqué est incorrect.',
	'CUSTOM_DATEFORMAT'   		=> 'Personnalisé…',

 	'DEFAULT_ACTION'   			=> 'Action par défaut',
	'DEFAULT_ACTION_EXPLAIN'   	=> 'Cette action sera activée si aucune ci-dessus n’est applicable.',
	'DEFAULT_ADD_SIG'   		=> 'Attacher ma signature',
	'DEFAULT_BBCODE'   			=> 'Activer les BBCodes',
	'DEFAULT_NOTIFY'   			=> 'Surveiller les réponses',
	'DEFAULT_SMILIES'   		=> 'Activer les smileys',
	'DEFINED_RULES'   			=> 'Filtres prédéfinis',
	'DELETED_TOPIC'   			=> 'Le sujet a été supprimé.',
	'DELETE_ATTACHMENT'   		=> 'Supprimer le fichier joint',
	'DELETE_ATTACHMENTS'   		=> 'Supprimer les fichiers joints',
	'DELETE_ATTACHMENT_CONFIRM' => 'Êtes-vous sûr de vouloir supprimer ce fichier joint?',
	'DELETE_ATTACHMENTS_CONFIRM'=> 'Êtes-vous sûr de vouloir supprimer ces fichiers joints?',
	'DELETE_AVATAR'   			=> 'Supprimer l’image',
	'DELETE_COOKIES_CONFIRM'   	=> 'Êtes-vous sûr de vouloir supprimer tous les cookies de ce forum?',
	'DELETE_MARKED_PM'   		=> 'Supprimer les messages sélectionnés',
	'DELETE_MARKED_PM_CONFIRM'  => 'Êtes-vous sûr de vouloir supprimer tous les messages sélectionnés?',
	'DELETE_OLDEST_MESSAGES'   	=> 'Supprimer les anciens messages',
	'DELETE_MESSAGE'   			=> 'Supprimer le message',
	'DELETE_MESSAGE_CONFIRM'   	=> 'Êtes-vous sûr de vouloir supprimer ce message privé?',
	'DELETE_MESSAGES_IN_FOLDER' => 'Supprimer définitivement tous les messages du dossier des messages supprimés',
	'DELETE_RULE'   			=> 'Supprimer le filtre',
	'DELETE_RULE_CONFIRM'   	=> 'Êtes-vous sûr de vouloir supprimer ce filtre?',
	'DEMOTE_SELECTED'   		=> 'Rétrograder de la sélection',
	'DISABLE_CENSORS'   		=> 'Activer la censure de mots',
	'DISPLAY_GALLERY'   		=> 'Afficher la galerie',
	'DOMAIN_NO_MX_RECORD_EMAIL' => 'Le domaine de l’adresse e-mail saisie n’est pas dans le registre MX.',
	'DOWNLOADS'   				=> 'Téléchargements',
	'DRAFTS_DELETED'   			=> 'Tous les brouillons sélectionnés ont été supprimés.',
	'DRAFTS_EXPLAIN'   			=> 'Ici, vous pouvez afficher, modifier et supprimer les brouillons enregistrés.',
	'DRAFT_UPDATED'   			=> 'Le brouillon a été mis à jour.',

	'EDIT_DRAFT_EXPLAIN'   		=> 'Vous pouvez modifier votre brouillon. Les brouillons ne contiennent pas les fichiers joints et les sondages.',
	'EMAIL_BANNED_EMAIL'   		=> 'L’adresse e-mail saisie est interdite.',
	'EMAIL_INVALID_EMAIL'   	=> 'L’adresse e-mail saisie est invalide.',
	'EMAIL_REMIND'				=> 'Adresse e-mail associée à votre compte. Si vous ne l’avez pas modifiée via votre panneau d’utilisateur, il s’agit de l’adresse que vous avez fournie lors de votre inscription.',
	'EMAIL_TAKEN_EMAIL'   		=> 'Cette adresse e-mail est déjà utilisée.',
	'EMPTY_DRAFT'   			=> 'Vous devez saisir un message pour créer un brouillon.',
	'EMPTY_DRAFT_TITLE'   		=> 'Vous devez saisir un titre pour le brouillon.',
	'EXPORT_AS_XML'   			=> 'Exporter en XML',
	'EXPORT_AS_CSV'   			=> 'Exporter en CSV',
	'EXPORT_AS_CSV_EXCEL'   	=> 'Exporter en CSV (Excel)',
	'EXPORT_AS_TXT'   			=> 'Exporter en TXT',
	'EXPORT_AS_MSG'   			=> 'Exporter en MSG',
	'EXPORT_FOLDER'   			=> 'Exporter le dossier',

	'FIELD_REQUIRED'   					=> 'Le champ “%s” doit être rempli.',
	'FIELD_TOO_SHORT'   				=> 'Le champ “%1$s” est trop court, il doit comporter %2$d caractères au minimum.',
	'FIELD_TOO_LONG'   					=> 'Le champ “%1$s” est trop long, il doit comporter %2$d caractères au maximum.',
	'FIELD_TOO_SMALL'   				=> 'La valeur de “%1$s” est trop petite, elle doit être de %2$d au minimum.',
	'FIELD_TOO_LARGE'   				=> 'La valeur de “%1$s” est trop grande, elle doit être de %2$d au maximum.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'  => 'Le champ “%s” comporte des caractères invalides, seuls les nombres sont permis.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'   	=> 'Le champ “%s” comporte des caractères invalides, seuls les caractères alphanumériques sont permis.',
	'FIELD_INVALID_CHARS_SPACERS_ONLY'  => 'Le champ “%s” comporte des caractères invalides, seuls les alphanumériques, espaces ou les caractères -+_[] sont permis.',
	'FIELD_INVALID_DATE'   				=> 'Le champ “%s” a une date invalide.',
	'FIELD_INVALID_VALUE'       		=> 'Le champ “%s” a une valeur invalide.',

	'FOE_MESSAGE'   			=> 'Message d’un ignoré',
	'FOES_EXPLAIN'   			=> 'Les ignorés sont les membres dont les messages ne seront pas entièrement visibles, mais ils peuvent toujours vous envoyer des messages privés. Notez que vous ne pouvez pas ignorer les modérateurs ou les administrateurs.',
	'FOES_UPDATED'   			=> 'Votre liste d’ignorés a été mise à jour.',
	'FOLDER_ADDED'   			=> 'Le dossier a été ajouté.',
	'FOLDER_MESSAGE_STATUS'   	=> '%1$d sur %2$d messages enregistrés',
	'FOLDER_NAME_EMPTY'			=> 'Vous devez taper un nom pour ce répertoire.',
	'FOLDER_NAME_EXIST'   		=> 'Le dossier <strong>%s</strong> existe déjà.',
	'FOLDER_OPTIONS'   			=> 'Options du dossier',
	'FOLDER_RENAMED'   			=> 'Le dossier a été renommé.',
	'FOLDER_REMOVED'   			=> 'Le dossier a été supprimé.',
	'FOLDER_STATUS_MSG'   		=> 'Dossier plein à %1$d%% (%2$d sur %3$d messages)',
	'FORWARD_PM'   				=> 'Transmettre le message privé',
	'FORCE_PASSWORD_EXPLAIN'   	=> 'Avant de continuer de consulter le forum, vous devez modifier votre mot de passe.',
	'FRIEND_MESSAGE'   			=> 'Message d’un ami',
	'FRIENDS'   				=> 'Amis',
	'FRIENDS_EXPLAIN'   		=> 'La liste d’amis permet un accès rapide aux membres avec lesquels vous discutez souvent. Si le style le permet, leurs messages seront mis en valeur.',
	'FRIENDS_OFFLINE'   		=> 'Hors ligne',
	'FRIENDS_ONLINE'   			=> 'En ligne',
	'FRIENDS_UPDATED'  			=> 'Votre liste d’amis a été mise à jour.',
	'FULL_FOLDER_OPTION_CHANGED'=> 'L’action à effectuer dès qu’un dossier est plein a été modifiée.',
	'FWD_ORIGINAL_MESSAGE'   	=> '-------- Message original --------',
	'FWD_SUBJECT'   			=> 'Sujet: %s',
	'FWD_DATE'   				=> 'Date: %s',
	'FWD_FROM'   				=> 'De: %s',
	'FWD_TO'   					=> 'A: %s',

	'GLOBAL_ANNOUNCEMENT'   => 'Annonce globale',

	'HIDE_ONLINE'   			=> 'Cacher mon statut en ligne',
	'HIDE_ONLINE_EXPLAIN'		=> 'Le changement de ce paramètre ne sera effectif que lors de votre prochaine connexion au forum.',
	'HOLD_NEW_MESSAGES'   		=> 'Refuser les nouveaux messages (dans l’attente d’espace disponible)',
	'HOLD_NEW_MESSAGES_SHORT'   => 'Renvoyer plus tard les nouveaux messages',

	'IF_FOLDER_FULL'   			=> 'Si le dossier est plein',
	'IMPORTANT_NEWS'   			=> 'Annonces importantes',
	'INVALID_USER_BIRTHDAY'		=> 'La date anniversaire indiquée est incorrecte.',
	'INVALID_CHARS_USERNAME'   	=> 'Le nom d’utilisateur contient des caractères interdits.',
	'INVALID_CHARS_NEW_PASSWORD'=> 'Le mot de passe ne contient pas les caractères requis.',
	'ITEMS_REQUIRED'   			=> 'Les éléments marqués par une * sont des champs obligatoires du profil et doivent être remplis.',

	'JOIN_SELECTED'   => 'Rejoindre la sélection',

	'LANGUAGE'   					=> 'Langue',
	'LINK_REMOTE_AVATAR'   			=> 'Lien distant',
	'LINK_REMOTE_AVATAR_EXPLAIN'  	=> 'Saisissez l’URL de l’image à utiliser pour votre avatar.',
	'LINK_REMOTE_SIZE'   			=> 'Dimensions de l’avatar',
	'LINK_REMOTE_SIZE_EXPLAIN'   	=> 'Précisez la largeur et la hauteur de l’avatar, laissez blanc pour tenter une vérification automatique.',
	'LOGIN_EXPLAIN_UCP'   			=> 'Connectez-vous pour accéder à votre panneau d’utilisateur.',
	'LOGIN_REDIRECT'   				=> 'Vous êtes maintenant connecté au forum.',
	'LOGOUT_FAILED'   				=> 'Vous n’avez pas été déconnecté car la requête ne correspondait pas à votre session. Si le problème persiste, contactez l’administrateur.',
	'LOGOUT_REDIRECT'   			=> 'Vous êtes maintenant déconnecté du forum.',

	'MARK_IMPORTANT'   				=> 'Marquer/Ne pas marquer comme important',
	'MARKED_MESSAGE'   				=> 'Message marqué',
	'MAX_FOLDER_REACHED'   			=> 'Le nombre maximum de dossiers a été atteint.',
	'MESSAGE_BY_AUTHOR'   			=> 'de',
	'MESSAGE_COLOURS'   			=> 'Couleurs du message',
	'MESSAGE_DELETED'   			=> 'Le message a été supprimé.',
	'MESSAGE_HISTORY'   			=> 'Revue du message',
	'MESSAGE_REMOVED_FROM_OUTBOX'   => 'Ce message a été supprimé par son auteur avant d’avoir été délivré.',
	'MESSAGE_SENT_ON'   			=> 'le',
	'MESSAGE_STORED'   				=> 'Votre message a été envoyé.',
	'MESSAGE_TO'   					=> 'A',
	'MESSAGES_DELETED'   			=> 'Les messages ont été supprimés',
	'MOVE_DELETED_MESSAGES_TO'   	=> 'Déplacer les messages supprimés vers',
	'MOVE_DOWN'   					=> 'Descendre',
	'MOVE_MARKED_TO_FOLDER'   		=> 'Déplacer la sélection vers %s',
	'MOVE_PM_ERROR'   				=> 'Une erreur est survenue en déplaçant les messages vers le nouveau dossier, seuls %1d des %2d messages ont été déplacés.',
	'MOVE_TO_FOLDER'   				=> 'Déplacer vers le dossier',
	'MOVE_UP'   					=> 'Monter',

	'NEW_EMAIL_ERROR'   			=> 'Les adresses e-mails saisies ne concordent pas.',
	'NEW_FOLDER_NAME'   			=> 'Nouveau nom de dossier',
	'NEW_PASSWORD'   				=> 'Nouveau mot de passe',
	'NEW_PASSWORD_ERROR'   			=> 'Les mots de passe saisis ne concordent pas.',
	'NOTIFY_METHOD'   				=> 'Méthode de notification',
	'NOTIFY_METHOD_BOTH'   			=> 'Les deux',
	'NOTIFY_METHOD_EMAIL'   		=> 'E-mail uniquement',
	'NOTIFY_METHOD_EXPLAIN'   		=> 'Méthode pour l’envoi de messages via ce forum.',
	'NOTIFY_METHOD_IM'   			=> 'Jabber uniquement',
	'NOTIFY_ON_PM'   				=> 'M’avertir des nouveaux messages privés',
	'NOT_ADDED_FRIENDS_ANONYMOUS'  	=> 'Vous ne pouvez pas ajouter un invité à votre liste d’amis.',
	'NOT_ADDED_FRIENDS_BOTS'		=> 'Vous ne pouvez pas ajouter de robots à votre liste d’amis.',
	'NOT_ADDED_FRIENDS_FOES'   		=> 'Vous ne pouvez pas ajouter à votre liste d’amis des utilisateurs qui sont sur votre liste d’ignorés.',
	'NOT_ADDED_FRIENDS_SELF'   		=> 'Vous ne pouvez pas vous ajouter à votre liste d’amis.',
	'NOT_ADDED_FOES_MOD_ADMIN'   	=> 'Vous ne pouvez pas ajouter d’administrateurs ni de modérateurs à votre liste d’ignorés.',
	'NOT_ADDED_FOES_ANONYMOUS'   	=> 'Vous ne pouvez pas ajouter un invité à votre liste d’ignorés.',
	'NOT_ADDED_FOES_BOTS'			=> 'Vous ne pouvez pas ajouter de robots à votre liste d’ignorés.',
	'NOT_ADDED_FOES_FRIENDS'   		=> 'Vous ne pouvez pas ajouter à votre liste d’ignorés des utilisateurs qui sont sur votre liste d’amis.',
	'NOT_ADDED_FOES_SELF'   		=> 'Vous ne pouvez pas vous ajouter à votre liste d’ignorés.',
	'NOT_AGREE'   					=> 'Je n’accepte pas ces conditions',
	'NOT_ENOUGH_SPACE_FOLDER'   	=> 'Le dossier “%s” est plein. L’action n’a pas été effectuée.',
	'NOT_MOVED_MESSAGE'   			=> 'Vous avez actuellement un message en attente car le dossier est plein.',
	'NOT_MOVED_MESSAGES'   			=> 'Vous avez %d messages en attente car le dossier est plein.',
	'NO_ACTION_MODE'   				=> 'Aucune action indiquée.',
	'NO_AUTHOR'   					=> 'Aucun auteur n’est défini pour ce message',
	'NO_AVATAR_CATEGORY'   			=> 'Aucune',

	'NO_AUTH_DELETE_MESSAGE'   		=> 'Vous n’êtes pas autorisé à supprimer les messages privés.',
	'NO_AUTH_EDIT_MESSAGE'   		=> 'Vous n’êtes pas autorisé à éditer les messages privés.',
	'NO_AUTH_FORWARD_MESSAGE'   	=> 'Vous n’êtes pas autorisé à transférer les messages privés.',
	'NO_AUTH_GROUP_MESSAGE'   		=> 'Vous n’êtes pas autorisé à envoyer de messages privés à des groupes.',
	'NO_AUTH_PASSWORD_REMINDER' 	=> 'Vous n’êtes pas autorisé à demander un nouveau mot de passe.',
	'NO_AUTH_READ_HOLD_MESSAGE' 	=> 'Vous n’êtes pas autorisé à lire les messages privés qui sont en attente.',
	'NO_AUTH_READ_MESSAGE' 			=> 'Vous n’êtes pas autorisé à lire les messages privés.',
	'NO_AUTH_READ_REMOVED_MESSAGE' 	=> 'Vous n’êtes pas autorisé à lire ce message privé car son auteur l’a supprimé.',
	'NO_AUTH_SEND_MESSAGE' 			=> 'Vous n’êtes pas autorisé à envoyer de messages privés.',
	'NO_AUTH_SIGNATURE'   			=> 'Vous n’êtes pas autorisé à créer de signature',

	'NO_BCC_RECIPIENT'   		=> 'Aucun',
	'NO_BOOKMARKS'   			=> 'Vous n’avez pas de favoris.',
	'NO_BOOKMARKS_SELECTED'   	=> 'Vous n’avez choisi aucun favori.',
	'NO_EDIT_READ_MESSAGE'		=> 'Ce message privé ne peut pas être édité, car il a déja été lu par son destinataire.',
	'NO_EMAIL_USER'  			=> 'L’e-mail/nom d’utilisateur fourni est introuvable.',
	'NO_FOES'   				=> 'Aucun ignoré actuellement',
	'NO_FRIENDS'   				=> 'Aucun ami actuellement',
	'NO_FRIENDS_OFFLINE'   		=> 'Aucun ami hors ligne',
	'NO_FRIENDS_ONLINE'   		=> 'Aucun ami en ligne',
	'NO_GROUP_SELECTED'   		=> 'Aucun groupe indiqué.',
	'NO_IMPORTANT_NEWS'   		=> 'Aucune annonce importante.',
	'NO_MESSAGE'   				=> 'Le message privé est introuvable.',
	'NO_NEW_FOLDER_NAME'  		=> 'Vous devez indiquer un nouveau nom de dossier.',
	'NO_NEWER_PM'   			=> 'Aucun nouveau message.',
	'NO_OLDER_PM'   			=> 'Aucun ancien message.',
	'NO_PASSWORD_SUPPLIED'   	=> 'Vous ne pouvez pas vous connecter sans mot de passe.',
	'NO_RECIPIENT'   			=> 'Aucun destinataire.',
	'NO_RULES_DEFINED'   		=> 'Aucun filtre défini.',
	'NO_SAVED_DRAFTS'   		=> 'Aucun brouillon sauvegardé.',
	'NO_TO_RECIPIENT'   		=> 'Aucun',
	'NO_WATCHED_FORUMS'   		=> 'Vous ne surveillez aucun forum.',
	'NO_WATCHED_SELECTED'		=> 'Vous n’avez sélectionné aucun forums ou sujets surveillés.',
	'NO_WATCHED_TOPICS'   		=> 'Vous ne surveillez aucun sujet.',

	'PASS_TYPE_ALPHA_EXPLAIN'   => 'Le mot de passe doit avoir une longueur comprise entre %1$d et %2$d caractères et doit contenir des lettres de casse mélangée et des chiffres.',
	'PASS_TYPE_ANY_EXPLAIN'   	=> 'Le mot de passe doit avoir une longueur comprise entre %1$d et %2$d caractères.',
	'PASS_TYPE_CASE_EXPLAIN'   	=> 'Le mot de passe doit avoir une longueur comprise entre %1$d et %2$d caractères et doit contenir des lettres de casse mélangée.',
	'PASS_TYPE_SYMBOL_EXPLAIN'  => 'Le mot de passe doit avoir une longueur comprise entre %1$d et %2$d caractères et doit contenir des lettres de casse mélangée, des chiffres et des symboles.',
	'PASSWORD'   				=> 'Mot de passe',
	'PASSWORD_ACTIVATED'   		=> 'Votre nouveau mot de passe a été activé.',
	'PASSWORD_UPDATED'   		=> 'Un nouveau mot de passe a été envoyé à votre adresse e-mail.',
	'PERMISSIONS_RESTORED'   	=> 'Les permissions d’origine ont été restaurées.',
	'PERMISSIONS_TRANSFERRED'   => 'Les permissions ont été transférées depuis <strong>%s</strong>, vous pouvez maintenant parcourir le forum avec les permissions de cet utilisateur.<br />Notez que les permissions d’administration n’ont pas été transférées. Vous pouvez réinitialiser vos permissions à tout moment.',
	'PM_DISABLED'   			=> 'La messagerie privée a été désactivée sur ce forum.',
	'PM_FROM'   				=> 'De',
	'PM_FROM_REMOVED_AUTHOR'   	=> 'Le message a été envoyé par un utilisateur qui n’est plus enregistré.',
	'PM_ICON'   				=> 'Icône de message',
	'PM_INBOX'   				=> 'Boîte de réception',
	'PM_NO_USERS'   			=> 'L’utilisateur que vous voulez ajouter n’existe pas.',
	'PM_OUTBOX'   				=> 'Boîte d’envoi',
	'PM_SENTBOX'   				=> 'Messages envoyés',
	'PM_SUBJECT'   				=> 'Sujet du message',
	'PM_TO'   					=> 'Envoyer à',
	'PM_USERS_REMOVED_NO_PM'   	=> 'Certains utilisateurs n’ont pas pu être ajoutés car ils ont désactivé leur boîte de messagerie privée.',
	'POPUP_ON_PM'   			=> 'Fenêtre pop-up lors de nouveaux messages privés',
	'POST_EDIT_PM'   			=> 'Editer le message',
	'POST_FORWARD_PM'   		=> 'Transmettre le message',
	'POST_NEW_PM'   			=> 'Envoyer',
	'POST_PM_LOCKED'   			=> 'La messagerie privée est verrouillée.',
	'POST_PM_POST'   			=> 'Poster le message',
	'POST_QUOTE_PM'   			=> 'Citer le message',
	'POST_REPLY_PM'   			=> 'Répondre au message',
	'PRINT_PM'   				=> 'Imprimer',
	'PREFERENCES_UPDATED'   	=> 'Vos préférences ont été mises à jour.',
	'PROFILE_INFO_NOTICE'   	=> 'Ces informations sont visibles par les autres membres. Soyez vigilant lors de la saisie d’informations personnelles. Tous les champs marqués par une * sont obligatoires.',
	'PROFILE_UPDATED'   		=> 'Votre profil a été mis à jour.',

	'RECIPIENT'  						=> 'Destinataire',
	'RECIPIENTS'   						=> 'Destinataires',
	'REGISTRATION'   					=> 'Inscription',
   	'RELEASE_MESSAGES'   				=> '%sRecevoir les messages en attente%s… ils seront reclassés dans les dossiers adéquats si l’espace nécessaire est disponible.',
	'REMOVE_ADDRESS'   					=> 'Supprimer l’adresse',
	'REMOVE_SELECTED_BOOKMARKS'  		=> 'Supprimer les favoris sélectionnés',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM' => 'Souhaitez-vous supprimer les favoris sélectionnés?',
	'REMOVE_BOOKMARK_MARKED'  	 		=> 'Supprimer',
	'REMOVE_FOLDER'   					=> 'Supprimer le dossier',
	'REMOVE_FOLDER_CONFIRM'   			=> 'Souhaitez-vous supprimer ce dossier?',
	'RENAME'   							=> 'Renommer',
	'RENAME_FOLDER'   					=> 'Renommer le dossier',
	'REPLIED_MESSAGE'   				=> 'Réponse au message',
	'REPLY_TO_ALL'						=> 'Répondre à l’expéditeur et à tous les destinataires.',
	'REPORT_PM'							=> 'Rapporter le message privé',
	'RESIGN_SELECTED'   				=> 'Démissionner de la sélection',
	'RETURN_FOLDER'   					=> '%1$sRetour au dossier précédent%2$s',
	'RETURN_UCP'   						=> '%sRetour au panneau de l’utilisateur%s',
	'RULE_ADDED'   						=> 'Le filtre a été ajouté.',
	'RULE_ALREADY_DEFINED'  			=> 'Ce filtre existe déjà.',
	'RULE_DELETED'   					=> 'Ce filtre a été supprimé.',
	'RULE_NOT_DEFINED'   				=> 'Ce filtre est incorrect.',
	'RULE_REMOVED_MESSAGE'   			=> 'Un message privé a été supprimé en raison des filtres de la messagerie privée.',
	'RULE_REMOVED_MESSAGES'   			=> '%d messages privés ont été supprimés en raison des filtres de la messagerie privée.',

	'SAME_PASSWORD_ERROR'   	=> 'Le nouveau mot de passe saisi est identique à votre mot de passe actuel.',
	'SEARCH_YOUR_POSTS'   		=> 'Voir vos messages',
	'SEND_PASSWORD'   			=> 'Envoyer votre mot de passe',
	'SENT_AT'   				=> 'Envoyé',	// Used before dates in private messages
	'SHOW_EMAIL'   				=> 'Recevoir les e-mails des utilisateurs',
	'SIGNATURE_EXPLAIN'   		=> 'Voici le texte qui peut être ajouté à vos messages. Il y a une limite de %d caractères.',
	'SIGNATURE_PREVIEW'   		=> 'Votre signature apparaîtra ainsi dans vos messages',
	'SIGNATURE_TOO_LONG'   		=> 'Votre signature est trop longue.',
	'SORT'   					=> 'Trier',
	'SORT_COMMENT'   			=> 'Commentaire',
	'SORT_DOWNLOADS'   			=> 'Téléchargements',
	'SORT_EXTENSION'   			=> 'Extension',
	'SORT_FILENAME'   			=> 'Nom du fichier',
	'SORT_POST_TIME'   			=> 'Date de publication',
	'SORT_SIZE'   				=> 'Taille du fichier',

	'TIMEZONE'   			=> 'Fuseau horaire',
	'TO'   					=> 'A',
	'TOO_MANY_RECIPIENTS' 	=> 'Vous avez essayé d’envoyer un message privé à trop de destinataires à la fois.',
	'TOO_MANY_REGISTERS'   	=> 'Vous avez atteint le nombre maximum de tentatives d’inscription. Réessayez plus tard.',

	'UCP'   				=> 'Panneau de l’utilisateur',
	'UCP_ACTIVATE'   		=> 'Activer le compte',
	'UCP_ADMIN_ACTIVATE'   	=> 'Notez que vous devez entrer une adresse e-mail valide pour activer votre compte. L’administrateur vérifiera votre compte et s’il est accepté vous recevrez un e-mail à l’adresse indiquée.',
	'UCP_AIM'   			=> 'Messagerie instantanée AOL',
	'UCP_ATTACHMENTS'   	=> 'Gestion des fichiers joints',
	'UCP_COPPA_BEFORE'   	=> 'Avant le %s',
	'UCP_COPPA_ON_AFTER'   	=> 'Le ou après le %s',
	'UCP_EMAIL_ACTIVATE'   	=> 'Notez que vous devez entrer une adresse e-mail valide pour activer votre compte. Vous recevrez un e-mail à l’adresse indiquée contenant le lien d’activation de votre compte.',
	'UCP_ICQ'   			=> 'Numéro ICQ',
	'UCP_JABBER'   			=> 'Adresse Jabber',

	'UCP_MAIN'   			=> 'Aperçu',
	'UCP_MAIN_ATTACHMENTS'  => 'Gestion des fichiers joints',
	'UCP_MAIN_BOOKMARKS'   	=> 'Gestion des favoris',
	'UCP_MAIN_DRAFTS'   	=> 'Gestion des brouillons',
	'UCP_MAIN_FRONT'   		=> 'Page principale',
	'UCP_MAIN_SUBSCRIBED'   => 'Gestion des surveillances',

	'UCP_MSNM'   			=> 'Windows Live Messenger',
	'UCP_NO_ATTACHMENTS'   	=> 'Aucun fichier envoyé.',

	'UCP_PREFS'   			=> 'Préférences du forum',
	'UCP_PREFS_PERSONAL'   	=> 'Modifier les préférences générales',
	'UCP_PREFS_POST'   		=> 'Modifier les préférences de message',
	'UCP_PREFS_VIEW'   		=> 'Modifier les options d’affichage',

	'UCP_PM'   				=> 'Messages privés',
	'UCP_PM_COMPOSE'   		=> 'Rédiger un message',
	'UCP_PM_DRAFTS'   		=> 'Gestion des brouillons de MP',
	'UCP_PM_OPTIONS'   		=> 'Paramètres des options',
	'UCP_PM_POPUP'   		=> 'Messages privés',
	'UCP_PM_POPUP_TITLE'   	=> 'Messages privés pop-up',
	'UCP_PM_UNREAD'   		=> 'Messages non lus',
	'UCP_PM_VIEW'   			=> 'Lire les messages',

	'UCP_PROFILE'   			=> 'Profil',
	'UCP_PROFILE_AVATAR'   		=> 'Modifier l’avatar',
	'UCP_PROFILE_PROFILE_INFO'  => 'Modifier le profil',
	'UCP_PROFILE_REG_DETAILS'   => 'Modifier les paramètres du compte',
	'UCP_PROFILE_SIGNATURE'  	=> 'Modifier la signature',

	'UCP_USERGROUPS'   		=> 'Groupes d’utilisateurs',
	'UCP_USERGROUPS_MEMBER' => 'Modifier les adhésions',
	'UCP_USERGROUPS_MANAGE' => 'Gestion des groupes',

	'UCP_REGISTER_DISABLE'   				=> 'L’enregistrement est temporairement désactivé.',
	'UCP_REMIND'   							=> 'Envoyer le mot de passe',
	'UCP_RESEND'   							=> 'Envoyer l’e-mail d’activation',
	'UCP_WELCOME'   						=> 'Bienvenue dans le panneau de l’utilisateur. D’ici vous pouvez surveiller, voir et modifier votre profil, vos préférences, les surveillances de forums et de sujets. Vous pouvez également (si vous y êtes autorisé) envoyer des messages à d’autres membres. Assurez-vous d’avoir lu toutes les annonces avant de continuer.',
	'UCP_YIM'   							=> 'Yahoo Messenger',
	'UCP_ZEBRA'   							=> 'Amis &amp; Ignorés',
	'UCP_ZEBRA_FOES'   						=> 'Gestion des ignorés',
	'UCP_ZEBRA_FRIENDS'   					=> 'Gestion des amis',
	'UNDISCLOSED_RECIPIENT'					=> 'Destinataire non divulgué',
	'UNKNOWN_FOLDER'   						=> 'Dossier inconnu',
	'UNWATCH_MARKED'   						=> 'Ne plus surveiller',
	'UPLOAD_AVATAR_FILE'   					=> 'Charger depuis votre ordinateur',
	'UPLOAD_AVATAR_URL'   					=> 'Charger depuis une URL',
	'UPLOAD_AVATAR_URL_EXPLAIN'   			=> 'Saisissez l’URL de l’image. L’image sera copiée vers ce site.',
	'USERNAME_ALPHA_ONLY_EXPLAIN'   		=> 'Le nom d’utilisateur doit contenir de %1$d à %2$d caractères et uniquement des caractères alphanumériques.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN' 		=> 'Le nom d’utilisateur doit contenir de %1$d à %2$d caractères et uniquement des caractères alphanumériques, espaces ou des caractères -+_[].',
	'USERNAME_ASCII_EXPLAIN'   				=> 'Le nom d’utilisateur doit contenir de %1$d à %2$d caractères et ne doit être composé que des caractères ASCII (pas de symboles spéciaux).',
	'USERNAME_LETTER_NUM_EXPLAIN'   		=> 'Le nom d’utilisateur doit contenir de %1$d à %2$d caractères et ne doit être composé que de lettres ou de chiffres.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'	=> 'Le nom d’utilisateur doit contenir de %1$d à %2$d caractères et peut être composé de lettres, de chiffres, d’espaces ou des caractères -+_[].',
	'USERNAME_CHARS_ANY_EXPLAIN'   			=> 'La longueur doit être comprise entre %1$d et %2$d caractères.',
	'USERNAME_TAKEN_USERNAME'   			=> 'Le nom d’utilisateur choisi est déjà utilisé, choisissez-en un autre.',
	'USERNAME_DISALLOWED_USERNAME'   		=> 'Le nom d’utilisateur indiqué à été banni ou bien contient un mot interdit. Choisissez-en un autre.',
	'USER_NOT_FOUND_OR_INACTIVE'   			=> 'Les noms d’utilisateurs indiqués sont introuvables ou sont des utilisateurs non activés.',

	'VIEW_AVATARS'   		=> 'Afficher les avatars',
	'VIEW_EDIT'   			=> 'Voir/modifier',
	'VIEW_FLASH'  			=> 'Afficher les animations Flash',
	'VIEW_IMAGES'   		=> 'Afficher les images dans les messages',
	'VIEW_NEXT_HISTORY'   	=> 'MP suivant chronologiquement',
	'VIEW_NEXT_PM'   		=> 'MP suivant',
	'VIEW_PM'   			=> 'Lire le message privé',
	'VIEW_PM_INFO'   		=> 'Détails du message',
	'VIEW_PM_MESSAGE'   	=> '1 message',
	'VIEW_PM_MESSAGES'   	=> '%d messages',
	'VIEW_PREVIOUS_HISTORY' => 'Historique de la conversation',
	'VIEW_PREVIOUS_PM'   	=> 'MP précédent',
	'VIEW_SIGS'   			=> 'Afficher les signatures',
	'VIEW_SMILIES'   		=> 'Afficher les smileys comme des images',
	'VIEW_TOPICS_DAYS'   	=> 'Afficher les sujets des jours précédents',
	'VIEW_TOPICS_DIR'   	=> 'Afficher les sujets dans un ordre',
	'VIEW_TOPICS_KEY'   	=> 'Afficher les sujets triés par',
	'VIEW_POSTS_DAYS'   	=> 'Afficher les messages des jours précédents',
	'VIEW_POSTS_DIR'   		=> 'Afficher les messages dans un ordre',
	'VIEW_POSTS_KEY'   		=> 'Afficher les messages triés par',

	'WATCHED_EXPLAIN'   	=> 'Vous pouvez afficher la liste des forums et sujets que vous surveillez. Vous serez informé des nouveaux messages écrits dans ceux-ci. Pour vous désabonner, cochez le forum ou le sujet et cliquez sur <em>Ne plus surveiller</em>.',
	'WATCHED_FORUMS'   		=> 'Forums surveillés',
	'WATCHED_TOPICS'   		=> 'Sujets surveillés',
	'WRONG_ACTIVATION'  	=> 'La clé d’activation envoyée ne correspond pas à celle de la base de données.',

	'YOUR_DETAILS'   		=> 'Votre activité',
	'YOUR_FOES'   			=> 'Vos ignorés',
	'YOUR_FOES_EXPLAIN'   	=> 'Pour supprimer des utilisateurs “ignorés”, sélectionnez-les et cliquez sur envoyer.',
	'YOUR_FRIENDS'   		=> 'Vos amis',
	'YOUR_FRIENDS_EXPLAIN'  => 'Pour supprimer des utilisateurs “amis”, sélectionnez-les et cliquez sur envoyer.',
	'YOUR_WARNINGS'   		=> 'Votre niveau d’avertissement',

	'PM_ACTION' => array(
   	'PLACE_INTO_FOLDER' => 'Placer dans le dossier',
   	'MARK_AS_READ'   	=> 'Marquer comme lu',
   	'MARK_AS_IMPORTANT' => 'Marquer le message',
   	'DELETE_MESSAGE'   	=> 'Supprimer le message'
   ),
	'PM_CHECK' => array(
   	'SUBJECT'   => 'Sujet',
   	'SENDER'   	=> 'Expéditeur',
   	'MESSAGE'   => 'Message',
   	'STATUS'   	=> 'Statut du message',
   	'TO'   		=> 'Envoyé'
   ),
	'PM_RULE' => array(
   	'IS_LIKE'   	=> 'contient',
   	'IS_NOT_LIKE'  	=> 'ne contient pas',
   	'IS'   			=> 'est',
   	'IS_NOT'   		=> 'n’est pas',
   	'BEGINS_WITH'   => 'commence par',
   	'ENDS_WITH'   	=> 'finit par',
   	'IS_FRIEND'   	=> 'est un ami',
   	'IS_FOE'   		=> 'est un ignoré',
   	'IS_USER'  	 	=> 'est l’utilisateur',
   	'IS_GROUP'   	=> 'est dans le groupe',
   	'ANSWERED'   	=> 'répondu',
   	'FORWARDED'   	=> 'transmis',
   	'TO_GROUP'   	=> 'à mon groupe par défaut',
   	'TO_ME'   		=> 'à moi'
   ),


	'GROUPS_EXPLAIN'   	=> 'Les groupes d’utilisateurs permettent aux administrateurs de mieux gérer leurs utilisateurs. Par défaut vous serez placé dans un groupe particulier, il s’agit de votre groupe par défaut. Ce groupe définit comment vous apparaissez sur le forum, par exemple la couleur de votre nom d’utilisateur, votre avatar, votre rang, etc. Si l’administrateur le permet, vous serez autorisé à changer votre groupe par défaut. Vous pouvez être placé ou rejoindre d’autres groupes. Certains groupes peuvent vous donner des permissions supplémentaires de lecture ou vous donner accès à d’autres fonctionnalités du forum.',
	'GROUP_LEADER'   	=> 'Chef de groupe',
	'GROUP_MEMBER'   	=> 'Membres',
	'GROUP_PENDING'  	=> 'Membres en attente',
	'GROUP_NONMEMBER'   => 'Non-membres',
	'GROUP_DETAILS'   	=> 'Informations sur le groupe',

	'NO_LEADER'   	=> 'Aucun modérateur de groupe',
	'NO_MEMBER'   	=> 'Aucun membre de groupe',
	'NO_PENDING'   	=> 'Aucun membre en attente',
	'NO_NONMEMBER'  => 'Aucun non-membre des groupes',
));

?>