<?php
/** 
*
* common [Standard french]
* translated originally by PhpBB-fr.com <http://www.phpbb-fr.com/> and phpBB.biz <http://www.phpBB.biz>
*
* @package language
* @version $Id: common.php, v1.27 13:53 10:21 14/06/2011 Lolovoisin Exp $
* @copyright (c) 2005 phpBB Group 
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Traduction par: <a href="http://forums.phpbb-fr.com">phpBB-fr.com</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'fr',

	'1_DAY'			=> '1 jour',
	'1_MONTH'		=> '1 mois',
	'1_YEAR'		=> '1 an',
	'2_WEEKS'		=> '2 semaines',
	'3_MONTHS'		=> '3 mois',
	'6_MONTHS'		=> '6 mois',
	'7_DAYS'		=> '7 jours',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Votre compte est déjà activé.',
	'ACCOUNT_DEACTIVATED'			=> 'Votre compte a été désactivé manuellement et n’est réactivable que par un administrateur.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Votre compte n’a pas encore été activé.',
	'ACP'							=> 'Panneau d’administration',
	'ACTIVE'						=> 'Actif',
	'ACTIVE_ERROR'					=> 'Le nom d’utilisateur indiqué est actuellement inactif. Si vous avez des problèmes pour activer votre compte, contactez l’administrateur du forum.',
	'ADMINISTRATOR'					=> 'Administrateur',
	'ADMINISTRATORS'				=> 'Administrateurs',
	'AGE'							=> 'Age',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Autorisé',
	'ALL_FILES'						=> 'Tous les fichiers',
	'ALL_FORUMS'					=> 'Tous les forums',
	'ALL_MESSAGES'					=> 'Tous les messages',
	'ALL_POSTS'						=> 'Tous',
	'ALL_TIMES'						=> 'Heures au format %1$s %2$s',
	'ALL_TOPICS'					=> 'Tous',
	'AND'							=> 'et',
	'ARE_WATCHING_FORUM'			=> 'Vous surveillez maintenant les nouveaux messages de ce forum.',
	'ARE_WATCHING_TOPIC'			=> 'Vous surveillez maintenant les nouveaux messages de ce sujet.',
	'ASCENDING'						=> 'Croissant',
	'ATTACHMENTS'					=> 'Fichiers joints',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Le fichier image que vous essayez de joindre n’est pas valide.',
	'AUTHOR'						=> 'Auteur',
	'AUTH_NO_PROFILE_CREATED'		=> 'Impossible de créer le nouveau profil de l’utilisateur.',
	'AVATAR_DISALLOWED_CONTENT' 	=> 'Le chargement a été rejeté car le fichier chargé a été identifié comme un vecteur éventuel d’attaque.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Ce fichier ne peut pas être affiché car l’extension <strong>%s</strong> n’est pas autorisée.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'L’avatar indiqué n’a pas pu être chargé car les données distantes semblent être invalides ou corrompues.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Le fichier avatar chargé est vide.',
	'AVATAR_INVALID_FILENAME'		=> '%s est un nom de fichier invalide.',
	'AVATAR_NOT_UPLOADED'			=> 'L’avatar n’a pas pu être chargé.',
	'AVATAR_NO_SIZE'				=> 'Impossible de déterminer la largeur ou la hauteur de l’avatar lié, entrez-les manuellement',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Le fichier n’a pu être que partiellement chargé.',
	'AVATAR_PHP_SIZE_NA'			=> 'La taille de l’avatar est trop importante.<br />La taille maximum réglée dans php.ini n’a pas pu être déterminée.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'La taille de l’avatar est trop importante. La taille maximum de chargement autorisée est %1$d %2$s.<br />Notez que ce paramètre est inscrit dans php.ini et ne peut pas être dépassé.',
	'AVATAR_URL_INVALID'			=> 'L’URL indiquée est invalide.',
	'AVATAR_URL_NOT_FOUND'			=> 'Le fichier indiqué est introuvable.',
	'AVATAR_WRONG_FILESIZE'			=> 'La taille de l’avatar doit être comprise entre 0 et %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'L’avatar envoyé a une largeur de %5$d pixels et une hauteur de %6$d pixels. Les avatars doivent faire au moins %1$d pixels de large et %2$d pixels de haut, mais au plus %3$d pixels de large et %4$d pixels de haut.',

	'BACK_TO_TOP'			=> 'Haut',
	'BACK_TO_PREV'			=> 'Retour à la page précédente',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Votre adresse e-mail a été bannie.',
	'BAN_TRIGGERED_BY_IP'	=> 'Votre adresse IP a été bannie.',
	'BAN_TRIGGERED_BY_USER'	=> 'Votre nom d’utilisateur a été banni.',
	'BBCODE_GUIDE'			=> 'Guide du BBCode',
	'BCC'					=> 'CCI',
	'BIRTHDAYS'				=> 'Anniversaires',
	'BOARD_BAN_PERM'		=> 'Vous avez été banni <strong>définitivement</strong> de ce forum.<br /><br />Contactez l’%2$sAdministrateur du forum%3$s pour plus d’informations.',
	'BOARD_BAN_REASON'		=> 'Raison du bannissement: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Vous avez été banni de ce forum jusqu’au <strong>%1$s</strong>.<br /><br />Contactez l’%2$sAdministrateur du forum%3$s pour plus d’informations.',
	'BOARD_DISABLE'			=> 'Désolé, mais ce forum est actuellement indisponible.',
	'BOARD_DISABLED'		=> 'Ce forum est actuellement désactivé.',
	'BOARD_UNAVAILABLE'		=> 'Désolé, mais le forum est temporairement indisponible, réessayez dans quelques minutes.',
	'BROWSING_FORUM'		=> 'Utilisateurs parcourant ce forum : %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Utilisateurs parcourant ce forum: %1$s et %2$d invité',
	'BROWSING_FORUM_GUESTS'	=> 'Utilisateurs parcourant ce forum: %1$s et %2$d invités',
	'BYTES'					=> 'Octets',

	'CANCEL'				=> 'Annuler',
	'CHANGE'				=> 'Valider',
	'CHANGE_FONT_SIZE'		=> 'Modifier la taille de la police',
	'CHANGING_PREFERENCES'	=> 'Modifie les préférences du forum',
	'CHANGING_PROFILE'		=> 'Modifie son profil',
	'CLICK_VIEW_PRIVMSG'	=> '%sAller à votre boîte de réception%s',
	'COLLAPSE_VIEW'			=> 'Réduire la vue',
	'CLOSE_WINDOW'			=> 'Fermer la fenêtre',
	'COLOUR_SWATCH'			=> 'Palette de couleurs',
	'COMMA_SEPARATOR'		=> ', ',		// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Confirmer',
	'CONFIRM_CODE'			=> 'Code de confirmation',
	'CONFIRM_CODE_EXPLAIN'	=> 'Entrez le code exactement comme vous le voyez dans l’image. Notez que le code n’est pas sensible à la casse.',
	'CONFIRM_CODE_WRONG'	=> 'Le code de confirmation que vous avez entré est incorrect.',
	'CONFIRM_OPERATION'		=> 'Êtes-vous sûr de vouloir effectuer cette opération?',
	'CONGRATULATIONS'		=> 'Félicitations à',
	'CONNECTION_FAILED'		=> 'La connexion a échouée.',
	'CONNECTION_SUCCESS'	=> 'Vous êtes connecté!',
	'COOKIES_DELETED'		=> 'Tous les cookies du forum ont été supprimés.',
	'CURRENT_TIME'			=> 'Nous sommes le %s',

	'DAY'					=> 'Jour',
	'DAYS'					=> 'jours',
	'DELETE'				=> 'Supprimer',
	'DELETE_ALL'			=> 'Tout supprimer',
	'DELETE_COOKIES'		=> 'Supprimer les cookies du forum',
	'DELETE_MARKED'			=> 'Supprimer la sélection',
	'DELETE_POST'			=> 'Supprimer le message',
	'DELIMITER'				=> 'Séparateur',
	'DESCENDING'			=> 'Décroissant',
	'DISABLED'				=> 'Désactivé',
	'DISPLAY'				=> 'Afficher',
	'DISPLAY_GUESTS'		=> 'Afficher les invités',
	'DISPLAY_MESSAGES'		=> 'Afficher les messages postés depuis',
	'DISPLAY_POSTS'			=> 'Afficher les messages postés depuis',
	'DISPLAY_TOPICS'		=> 'Afficher les sujets postés depuis',
	'DOWNLOADED'			=> 'Téléchargé',
	'DOWNLOADING_FILE'		=> 'Téléchargement en cours',
	'DOWNLOAD_COUNT'		=> 'Téléchargé %d fois',
	'DOWNLOAD_COUNTS'		=> 'Téléchargé %d fois',
	'DOWNLOAD_COUNT_NONE'	=> 'Pas encore téléchargé',
	'VIEWED_COUNT'			=> 'Vu %d fois',
	'VIEWED_COUNTS'			=> 'Vu %d fois',
	'VIEWED_COUNT_NONE'		=> 'Pas encore vu',

	'EDIT_POST'							=> 'Editer le message',
	'EMAIL'								=> 'E-mail', 	// Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Adresse e-mail',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Un problème est survenu lors de l’envoi de l’e-mail à la <strong>ligne %1$s</strong>. Réponse: %2$s.',
	'EMPTY_SUBJECT'						=> 'Vous devez indiquer un titre pour poster un nouveau sujet.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Vous devez indiquer un sujet quand vous envoyez un nouveau message.',
	'ENABLED'							=> 'Activé',
	'ENCLOSURE'							=> 'Clôture',
	'ERR_CHANGING_DIRECTORY'			=> 'Impossible de changer de répertoire.',
	'ERR_CONNECTING_SERVER'				=> 'Erreur de connexion au serveur.',
	'ERR_JAB_AUTH'						=> 'Impossible de s’authentifier sur le serveur Jabber.',
	'ERR_JAB_CONNECT'					=> 'Impossible de se connecter sur le serveur Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Le nom d’utilisateur ou le mot de passe indiqué est incorrect.',
	'ERR_UNWATCHING' 					=> 'Une erreur est survenue pendant la tentative de désinscription.',
	'ERR_WATCHING' 						=> 'Une erreur est survenue pendant la tentative d’inscription.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Le chemin phpBB indiqué ne semble pas être valide.',
	'EXPAND_VIEW'						=> 'Etendre la vue',
	'EXTENSION'							=> 'Extension',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'L’extension <strong>%s</strong> a été désactivée et ne peut plus être affichée.',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Foire aux questions (Questions posées fréquemment)',
	'FILENAME'				=> 'Nom',
	'FILESIZE'				=> 'Taille',
	'FILEDATE'				=> 'Date',
	'FILE_COMMENT'			=> 'Commentaire',
	'FILE_NOT_FOUND'		=> 'Le fichier recherché est introuvable.',
	'FIND_USERNAME'			=> 'Rechercher un membre',
	'FOLDER'				=> 'Dossier',
	'FORGOT_PASS'			=> 'J’ai oublié mon mot de passe',
	'FORM_INVALID'			=> 'Le formulaire envoyé est invalide. Essayez à nouveau.',
	'FORUM'					=> 'Forums',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'Les forums sélectionnés ont été marqués comme lus.',
	'FORUM_CAT'				=> 'Catégorie du forum',
	'FORUM_INDEX'			=> 'Index du forum',
	'FORUM_LINK'			=> 'Forum-lien',
	'FORUM_LOCATION'		=> 'Localisation sur le forum',
	'FORUM_LOCKED'			=> 'Forum verrouillé',
	'FORUM_RULES'			=> 'Règles du forum',
	'FORUM_RULES_LINK'		=> 'Cliquez pour voir les règles du forum',
	'FROM'					=> 'de',
	'FSOCK_DISABLED'		=> 'Impossible de finir cette opération car la fonction <var>fsockopen</var> est désactivée ou le serveur requis n’a pas pu être trouvé.',

	'FTP_FSOCK_HOST'				=> 'Serveur FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Serveur FTP utilisé pour se connecter à votre site.',
	'FTP_FSOCK_PASSWORD'			=> 'Mot de passe FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Mot de passe pour votre compte FTP.',
	'FTP_FSOCK_PORT'				=> 'Port FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port utilisé pour se connecter à votre serveur.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Chemin vers phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Chemin depuis la racine vers votre forum phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'Temps d’attente FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'La durée en secondes que le système attendra pour une réponse de votre serveur.',
	'FTP_FSOCK_USERNAME'			=> 'Nom d’utilisateur FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nom d’utilisateur utilisé pour se connecter à votre serveur.',

	'FTP_HOST'					=> 'Serveur FTP',
	'FTP_HOST_EXPLAIN'			=> 'Serveur FTP utilisé pour se connecter à votre site.',
	'FTP_PASSWORD'				=> 'Mot de passe FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Mot de passe pour votre compte FTP.',
	'FTP_PORT'					=> 'Port FTP',
	'FTP_PORT_EXPLAIN'			=> 'Port utilisé pour se connecter à votre serveur.',
	'FTP_ROOT_PATH'				=> 'Chemin vers phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Chemin depuis la racine vers votre forum phpBB.',
	'FTP_TIMEOUT'				=> 'Temps d’attente FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'La durée en secondes que le système attendra pour une réponse de votre serveur.',
	'FTP_USERNAME'				=> 'Nom d’utilisateur FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Nom d’utilisateur utilisé pour se connecter à votre serveur.',

	'GENERAL_ERROR'				=> 'Erreur générale',
	'GB'						=> 'Go',
	'GIB'						=> 'Gio',
	'GO'						=> 'Aller',
	'GOTO_PAGE'					=> 'Aller à la page',
	'GROUP'						=> 'Groupe',
	'GROUPS'					=> 'Groupes',
	'GROUP_ERR_TYPE'			=> 'Le type de groupe indiqué est inapproprié.',
	'GROUP_ERR_USERNAME'		=> 'Aucun nom de groupe indiqué.',
	'GROUP_ERR_USER_LONG'		=> 'Les noms de groupe ne peuvent pas dépasser 60 caractères. Le nom du groupe indiqué est trop long.',
	'GUEST'						=> 'Invité',
	'GUEST_USERS_ONLINE'		=> 'Il y a %d invités en ligne',
	'GUEST_USERS_TOTAL'			=> '%d invités',
	'GUEST_USERS_ZERO_ONLINE'	=> '0 invité en ligne',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 invité',
	'GUEST_USER_ONLINE'			=> 'Il y a %d invité en ligne',
	'GUEST_USER_TOTAL'			=> '%d invité',
	'G_ADMINISTRATORS'			=> 'Administrateurs',
	'G_BOTS'					=> 'Robots',
	'G_GUESTS'					=> 'Invités',
	'G_REGISTERED'				=> 'Utilisateurs enregistrés',
	'G_REGISTERED_COPPA'		=> 'Utilisateurs COPPA enregistrés',
	'G_GLOBAL_MODERATORS'		=> 'Modérateurs globaux',
	'G_NEWLY_REGISTERED'		=> 'Nouveaux utilisateurs enregistrés',

	'HIDDEN_USERS_ONLINE'		=> '%d utilisateurs invisibles en ligne',
	'HIDDEN_USERS_TOTAL'		=> '%d invisibles',
	'HIDDEN_USERS_TOTAL_AND'	=> '%d invisibles et ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 utilisateur invisible en ligne',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 invisible',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 invisible et ',
	'HIDDEN_USER_ONLINE'		=> '%d utilisateur invisible en ligne',
	'HIDDEN_USER_TOTAL'			=> '%d invisible',
	'HIDDEN_USER_TOTAL_AND'		=> '%d invisible et ',
	'HIDE_GUESTS'				=> 'Masquer les invités',
	'HIDE_ME'					=> 'Cacher mon statut en ligne pour cette session',
	'HOURS'						=> 'Heures',
	'HOME'						=> 'Accueil',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Statut ICQ',	
	'IF'						=> 'Si',
	'IMAGE'						=> 'Image',
	'IMAGE_FILETYPE_INVALID'	=> 'Le type de fichier image %d pour le type mime %s n’est pas supporté.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Type de fichier image incorrect: l’extension %1$s était attendue mais l’extension %2$s a été trouvée.',
	'IN'						=> 'dans',
	'INDEX'						=> 'Page d’index',
	'INFORMATION'				=> 'Informations',
	'INTERESTS'					=> 'Centres d’intérêt',
	'INVALID_DIGEST_CHALLENGE'	=> 'Défi invalide.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> est peut-être une adresse invalide?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Votre IP %1$s a été bloquée car elle est dans la liste noire. Pour plus d’informations, consultez <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Inscription',
	'JUMP_PAGE'				=> 'Entrer le numéro de page où vous souhaitez aller.',
	'JUMP_TO'				=> 'Aller à',
	'JUMP_TO_PAGE'			=> 'Cliquer pour aller à la page…',

	'KB'					=> 'Ko',
	'KIB'					=> 'Kio',

	'LAST_POST'							=> 'Dernier message',
	'LAST_UPDATED'						=> 'Dernière mise à jour',
	'LAST_VISIT'						=> 'Dernière visite',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Extension LDAP indisponible.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Impossible de se connecter au serveur LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Une erreur est survenue pendant la recherche du répertoire LDAP.',
	'LEGEND'							=> 'Légende',
	'LOCATION'							=> 'Localisation',
	'LOCK_POST'							=> 'Verrouiller le message',
	'LOCK_POST_EXPLAIN'					=> 'Empêche l’édition du message',
	'LOCK_TOPIC'						=> 'Verrouiller le sujet',
	'LOGIN'								=> 'Connexion',
	'LOGIN_CHECK_PM'					=> 'Se connecter pour vérifier ses messages privés.',
	'LOGIN_CONFIRMATION'				=> 'Confirmation de connexion',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Pour éviter une usurpation des comptes, l’administrateur du forum exige que vous entriez un code de confirmation visuelle après un certain nombre d’échecs. Le code est indiqué dans l’image que vous devez voir ci-dessous. Si vous êtes déficient visuel ou que vous ne pouvez pas lire ce code, contactez %sl’administrateur%s du forum.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Vous avez dépassé le maximum autorisé de tentatives de connexion. En plus de vos nom d’utilisateur et mot de passe, vous devez maintenant résoudre le CAPTCHA ci-dessous.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Vous n’avez pas été authentifié par Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Vous avez indiqué un mot de passe incorrect. Vérifiez votre mot de passe et réessayez. Si vous continuez à rencontrer des problèmes, contactez l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Il n’a pas été possible de convertir votre mot de passe lors de la mise à jour du forum. %sRedemandez un mot de passe%s. Si le problème persiste, contactez l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Vous avez indiqué un nom d’utilisateur incorrect. Vérifiez votre nom d’utilisateur et réessayez. Si vous continuez à rencontrer des problèmes, contactez l’%sadministrateur du forum%s.',
	'LOGIN_FORUM'						=> 'Pour lire ou poster dans ce forum, vous devez entrer son mot de passe.',
	'LOGIN_INFO'						=> 'Vous devez être enregistré pour vous connecter. L’enregistrement ne prend que quelques secondes et augmente vos possibilités. L’administrateur du forum peut également accorder des permissions additionnelles aux utilisateurs enregistrés. Avant de vous enregistrer, assurez-vous d’avoir pris connaissance de nos conditions d’utilisation et de notre politique de vie privée. Assurez-vous de bien lire tout le règlement du forum.',
	'LOGIN_VIEWFORUM'					=> 'L’administrateur du forum exige que vous soyez enregistré et connecté pour lire ce forum.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Pour éditer des messages dans ce forum, vous devez être enregistré et connecté.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Pour consulter la liste des utilisateurs en ligne, vous devez être enregistré et connecté.',
	'LOGOUT'							=> 'Déconnexion',
	'LOGOUT_USER'						=> 'Déconnexion [ %s ]',
	'LOG_ME_IN'							=> 'Me connecter automatiquement à chaque visite',

	'MARK'					=> 'Cocher',
	'MARK_ALL'				=> 'Tout cocher',
	'MARK_FORUMS_READ'		=> 'Marquer tous les forums comme lus',
	'MARK_SUBFORUMS_READ' 	=> 'Marquer tous les sous-forums comme lus',
	'MB'					=> 'Mo',
	'MIB'					=> 'Mio',
	'MCP'					=> 'Panneau de modération',
	'MEMBERLIST'			=> 'Membres',
	'MEMBERLIST_EXPLAIN'	=> 'Voir la liste complète des membres',
	'MERGE'					=> 'Fusionner',
	'MERGE_POSTS'			=> 'Déplacer les messages',
	'MERGE_TOPIC'			=> 'Fusionner le sujet',
	'MESSAGE'				=> 'Message',
	'MESSAGES'				=> 'Messages',
	'MESSAGE_BODY'			=> 'Corps du message',
	'MINUTES'				=> 'Minutes',
	'MODERATE'				=> 'Modérer',
	'MODERATOR'				=> 'Modérateur',
	'MODERATORS'			=> 'Modérateurs',
	'MONTH'					=> 'Mois',
	'MOVE'					=> 'Déplacer',
	'MSNM'					=> 'WLM',	

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'L’utilisateur enregistré le plus récent est <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nouveau message',
	'NEW_MESSAGES'				=> 'Nouveaux messages',
	'NEW_PM'					=> '<strong>%d</strong> nouveau message privé',
	'NEW_PMS'					=> '<strong>%d</strong> nouveaux messages privés',
	'NEW_POST'					=> 'Nouveau message',	// Not used anymore
	'NEW_POSTS'					=> 'Nouveaux messages',	// Not used anymore
	'NEXT'						=> 'Suivante',		// Used in pagination
	'NEXT_STEP'					=> 'Suivant',
	'NEVER'						=> 'Jamais',
	'NO'						=> 'Non',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Vous n’êtes pas autorisé à gérer ce groupe.',
	'NOT_AUTHORISED'			=> 'Vous n’êtes pas autorisé à accéder à cette partie du forum.',
	'NOT_WATCHING_FORUM'		=> 'Vous ne surveillez plus ce forum.',
	'NOT_WATCHING_TOPIC'		=> 'Vous ne surveillez plus ce sujet.',
	'NOTIFY_ADMIN'				=> 'Contactez l’administrateur du forum ou le webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Contactez l’administrateur du forum ou le webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Vous n’êtes pas autorisé à accéder à ce fichier.',
	'NO_ACTION'					=> 'Aucune action indiquée.',
	'NO_ADMINISTRATORS'			=> 'Il n’existe aucun administrateur.',
	'NO_AUTH_ADMIN'				=> 'Vous n’avez pas les permissions d’administration et ne pouvez donc pas accéder au panneau d’administration.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Vous ne pouvez pas vous ré-authentifier avec un compte différent.',
	'NO_AUTH_OPERATION'			=> 'Vous n’avez pas les permissions nécessaires pour accomplir cette opération.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Impossible de se connecter au serveur smtp : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Pas d’anniversaire à fêter aujourd’hui',
	'NO_EMAIL_MESSAGE'			=> 'Le contenu de cet e-mail est vide.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Impossible de récupérer les codes de réponse du serveur.',
	'NO_EMAIL_SUBJECT'			=> 'Aucun sujet n’a été indiqué.',
	'NO_FORUM'					=> 'Le forum que vous avez tenté d’atteindre n’existe pas.',
	'NO_FORUMS'					=> 'Aucun forum.',
	'NO_GROUP'					=> 'Le groupe demandé n’existe pas.',
	'NO_GROUP_MEMBERS'			=> 'Aucun membre dans ce groupe.',
	'NO_IPS_DEFINED'			=> 'Aucune IP ou nom d’hôte',
	'NO_MEMBERS'				=> 'Aucun membre trouvé pour ce critère de recherche.',
	'NO_MESSAGES'				=> 'Pas de message',
	'NO_MODE'					=> 'Pas de mode indiqué.',
	'NO_MODERATORS'				=> 'Il n’existe aucun modérateur.',
	'NO_NEW_MESSAGES'			=> 'Pas de nouveau message',
	'NO_NEW_PM'					=> '<strong>0</strong> nouveau message privé',
	'NO_NEW_POSTS'				=> 'Pas de nouveau message',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Aucun utilisateur enregistré',
	'NO_POSTS'					=> 'Pas de message',
	'NO_POSTS_TIME_FRAME'		=> 'Aucun message n’a été posté dans ce sujet pour la période indiquée.',
	'NO_FEED_ENABLED'			=> 'Les flux ne sont pas disponibles sur ce forum.',
	'NO_FEED'					=> 'Le flux demandé n’est pas disponible.',
	'NO_SUBJECT'				=> 'Aucun sujet indiqué',			// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'La recherche indiquée n’existe pas.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Aucune méthode d’authentification supportée.',
	'NO_TOPIC'					=> 'Le sujet demandé n’existe pas.',
	'NO_TOPIC_FORUM'			=> 'Le sujet ou le forum n’existe plus.',
	'NO_TOPICS'					=> 'Il n’y a aucun sujet ou message dans ce forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Aucun sujet n’a été posté dans ce forum pour la période indiquée.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> message non lu',
	'NO_UNREAD_POSTS'			=> 'Aucun message non lu',
	'NO_UPLOAD_FORM_FOUND'		=> 'Le chargement a commencé mais aucun fichier valide n’a été trouvé.',
	'NO_USER'					=> 'L’utilisateur demandé n’existe pas.',
	'NO_USERS'					=> 'Les utilisateurs demandés n’existent pas.',
	'NO_USER_SPECIFIED'			=> 'Aucun nom d’utilisateur indiqué.',
	
	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE' => array(
		0 => 'Aucun message en attente', // 0
		1 => '1 message en attente', // 1
		2 => '%d messages en attente', // 2+
	),

	'OCCUPATION'				=> 'Emploi',
	'OFFLINE'					=> 'Hors ligne',
	'ONLINE'					=> 'En ligne',
	'ONLINE_BUDDIES'			=> 'Amis en ligne',
	'ONLINE_USERS_TOTAL'		=> 'Au total il y a <strong>%d</strong> utilisateurs en ligne :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Au total il y a <strong>0</strong> utilisateur en ligne :: ',
	'ONLINE_USER_TOTAL'			=> 'Au total il y a <strong>%d</strong> utilisateur en ligne :: ',
	'OPTIONS'					=> 'Options',

	'PAGE_OF'				=> 'Page <strong>%1$d</strong> sur <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Page %s',
	'PASSWORD'				=> 'Mot de passe',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Jouer le fichier Quicktime',
	'PM'					=> 'MP',
	'PM_REPORTED'			=> 'Cliquer pour voir le rapport',
	'POSTING_MESSAGE'		=> 'Poste un message dans %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Rédige un message privé',
	'POST'					=> 'Message',
	'POST_ANNOUNCEMENT'		=> 'Annonce',
	'POST_STICKY'			=> 'Post-it',
	'POSTED'				=> 'Posté',
	'POSTED_IN_FORUM'		=> 'Dans',
	'POSTED_ON_DATE'		=> 'le',
	'POSTS'					=> 'Messages',
	'POSTS_UNAPPROVED'		=> 'Au moins un message de ce sujet n’a pas été approuvé.',
	'POST_BY_AUTHOR'		=> 'de',
	'POST_BY_FOE'			=> 'Ce message a été rédigé par <strong>%1$s</strong> qui est actuellement sur votre liste de membres ignorés. %2$sAfficher le message%3$s.',
	'POST_DAY'				=> '%.2f messages par jour',
	'POST_DETAILS'			=> 'Détails',
	'POST_NEW_TOPIC'		=> 'Poster un nouveau sujet',
	'POST_PCT'				=> '%.2f%% de tous les messages',
	'POST_PCT_ACTIVE'		=> '%.2f%% des messages de l’utilisateur',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% de vos messages',
	'POST_REPLY'			=> 'Répondre',
	'POST_REPORTED'			=> 'Cliquer pour voir le rapport',
	'POST_SUBJECT'			=> 'Sujet du message',
	'POST_TIME'				=> 'Date',
	'POST_TOPIC'			=> 'Ecrire un nouveau sujet',
	'POST_UNAPPROVED'		=> 'Ce message est en attente d’approbation',
	'PREVIEW'				=> 'Aperçu',
	'PREVIOUS'				=> 'Précédente',				// Used in pagination
	'PREVIOUS_STEP'			=> 'Précédente',
	'PRIVACY'				=> 'Politique de vie privée',
	'PRIVATE_MESSAGE'		=> 'Message privé',
	'PRIVATE_MESSAGES'		=> 'Messages privés',
	'PRIVATE_MESSAGING'		=> 'Messagerie privée',
	'PROFILE'				=> 'Panneau de l’utilisateur',

	'READING_FORUM'				=> 'Consulte les sujets dans %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Consulte une annonce globale',
	'READING_LINK'				=> 'Consulte le lien du forum %s',
	'READING_TOPIC'				=> 'Consulte un sujet dans %s',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Raison',
	'RECORD_ONLINE_USERS'		=> 'Le record du nombre d’utilisateurs en ligne est de <strong>%1$s</strong>, le %2$s',
	'REDIRECT'					=> 'Rediriger',
	'REDIRECTS'					=> 'Nombre de redirections',
	'REGISTER'					=> 'M’enregistrer',
	'REGISTERED_USERS'			=> 'Utilisateurs enregistrés :',
	'REG_USERS_ONLINE'			=> 'Il y a %d utilisateurs enregistrés et ',
	'REG_USERS_TOTAL'			=> '%d enregistrés, ',
	'REG_USERS_TOTAL_AND'		=> '%d enregistrés et ',
	'REG_USERS_ZERO_ONLINE'		=> 'Il y a 0 utilisateur enregistré et ',
	'REG_USERS_ZERO_TOTAL'		=> '0 enregistré, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 enregistré et ',
	'REG_USER_ONLINE'			=> 'Il y a %d utilisateur enregistré et ',
	'REG_USER_TOTAL'			=> '%d enregistré, ',
	'REG_USER_TOTAL_AND'		=> '%d enregistré et ',
	'REMOVE'					=> 'Supprimer',
	'REMOVE_INSTALL'			=> 'Pour finaliser l’installation du forum, supprimez, déplacez ou renommez le dossier install de votre espace FTP. Si ce dossier est toujours présent, seul le panneau d’administration (ACP) sera accessible.',
	'REPLIES'					=> 'Réponses',
	'REPLY_WITH_QUOTE'			=> 'Répondre en citant le message',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Répond à une annonce globale',
	'REPLYING_MESSAGE'			=> 'Répond au message dans %s',
	'REPORT_BY'					=> 'Rapporté par',
	'REPORT_POST'				=> 'Rapporter le message',
	'REPORTING_POST'			=> 'Rapporter un message',
	'RESEND_ACTIVATION'			=> 'Renvoyer l’e-mail de confirmation',
	'RESET'						=> 'Remettre à zéro',
	'RESTORE_PERMISSIONS'		=> 'Rétablir les permissions',
	'RETURN_INDEX'				=> '%sRetourner à l’index du forum%s',
	'RETURN_FORUM'				=> '%sRetourner au dernier forum visité%s',
	'RETURN_PAGE'				=> '%sRetourner à la page précédente%s',
	'RETURN_TOPIC'				=> '%sRetourner au dernier sujet visité%s',
	'RETURN_TO'					=> 'Retourner vers',
	'FEED'						=> 'Flux',
	'FEED_NEWS'					=> 'Nouvelles informations',
	'FEED_TOPICS_ACTIVE'		=> 'Sujets actifs',
 	'FEED_TOPICS_NEW'			=> 'Nouveaux sujets',
	'RULES_ATTACH_CAN'			=> 'Vous <strong>pouvez</strong> joindre des fichiers',
	'RULES_ATTACH_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> joindre des fichiers',
	'RULES_DELETE_CAN'			=> 'Vous <strong>pouvez</strong> supprimer vos messages',
	'RULES_DELETE_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> supprimer vos messages',
	'RULES_DOWNLOAD_CAN'		=> 'Vous <strong>pouvez</strong> télécharger des fichiers joints',
	'RULES_DOWNLOAD_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> télécharger des fichiers joints',
	'RULES_EDIT_CAN'			=> 'Vous <strong>pouvez</strong> éditer vos messages',
	'RULES_EDIT_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> éditer vos messages',
	'RULES_LOCK_CAN'			=> 'Vous <strong>pouvez</strong> verrouiller vos sujets',
	'RULES_LOCK_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> verrouiller vos sujets',
	'RULES_POST_CAN'			=> 'Vous <strong>pouvez</strong> poster de nouveaux sujets',
	'RULES_POST_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> poster de nouveaux sujets',
	'RULES_REPLY_CAN'			=> 'Vous <strong>pouvez</strong> répondre aux sujets',
	'RULES_REPLY_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> répondre aux sujets',
	'RULES_VOTE_CAN'			=> 'Vous <strong>pouvez</strong> participer aux votes',
	'RULES_VOTE_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> participer aux votes',

	'SEARCH'					=> 'Rechercher',
	'SEARCH_MINI'				=> 'Recherche…',
	'SEARCH_ADV'				=> 'Recherche avancée',
	'SEARCH_ADV_EXPLAIN'		=> 'Voir les options de recherche avancée',
	'SEARCH_KEYWORDS'			=> 'Recherche par mots-clés',
	'SEARCHING_FORUMS'			=> 'Recherche dans les forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'Voir les sujets actifs',
	'SEARCH_FOR'				=> 'Rechercher',
	'SEARCH_FORUM'				=> 'Dans ce forum…',	
	'SEARCH_NEW'				=> 'Voir les nouveaux messages',
	'SEARCH_POSTS_BY'			=> 'Rechercher les messages de',
	'SEARCH_SELF'				=> 'Voir mes messages',
	'SEARCH_TOPIC'				=> 'Dans ce sujet…',
	'SEARCH_UNANSWERED'			=> 'Voir les messages sans réponses',
	'SEARCH_UNREAD'				=> 'Voir les messages non lus',
	'SEARCH_USER_POSTS'  		=> 'Rechercher les messages de l’utilisateur',
	'SECONDS'					=> 'secondes',
	'SELECT'					=> 'Sélectionner',
	'SELECT_ALL_CODE'			=> 'Tout sélectionner',
	'SELECT_DESTINATION_FORUM'	=> 'Choisissez un forum de destination',
	'SELECT_FORUM'				=> 'Sélectionner un forum',
	'SEND_EMAIL'				=> 'Envoyer un e-mail',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Envoyer un e-mail à',			// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Envoyer un message privé',
	'SETTINGS'					=> 'Paramètres',
	'SIGNATURE'					=> 'Signature',
	'SKIP'						=> 'Vers le contenu',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Le serveur SMTP ne peut pas vous identifier.',
	'SORRY_AUTH_READ'			=> 'Vous n’êtes pas autorisé à lire ce forum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Vous n’êtes pas autorisé à télécharger ce fichier joint.',
	'SORT_BY'					=> 'Trier par',
	'SORT_JOINED'				=> 'Date d’inscription',
	'SORT_LOCATION'				=> 'Localisation',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Messages',
	'SORT_TOPIC_TITLE'			=> 'Titre du sujet',
	'SORT_USERNAME'				=> 'Nom d’utilisateur',
	'SPLIT_TOPIC'				=> 'Diviser le sujet',
	'SQL_ERROR_OCCURRED'		=> 'Une erreur SQL est arrivée en chargeant cette page. Contactez l’%sadministrateur du forum%s si ce problème persiste.',
	'STATISTICS'				=> 'Statistiques',
	'START_WATCHING_FORUM'		=> 'Surveiller ce forum',
	'START_WATCHING_TOPIC'		=> 'Surveiller ce sujet',
	'STOP_WATCHING_FORUM'		=> 'Arrêter de surveiller ce forum',
	'STOP_WATCHING_TOPIC'		=> 'Arrêter de surveiller ce sujet',
	'SUBFORUM'					=> 'Sous-forum',
	'SUBFORUMS'					=> 'Sous-forums',
	'SUBJECT'					=> 'Sujet',
	'SUBMIT'					=> 'Envoyer',

	'TERMS_USE'			=> 'Conditions d’utilisation',
	'TEST_CONNECTION'	=> 'Test de connexion',
	'THE_TEAM'			=> 'L’équipe du forum',
	'TIME'				=> 'Date',

	'TOO_LARGE'						=> 'La valeur saisie est trop grande.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'La valeur du réglage <strong>Nombre maximum autorisé de destinataires par message privé</strong> que vous avez saisie est trop grande.',

	'TOO_LONG' 			=> 'La valeur saisie est trop longue.',

	'TOO_LONG_AIM'					=> 'Le pseudonyme AIM indiqué est trop long.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Le code de confirmation indiqué est trop long.',
	'TOO_LONG_DATEFORMAT'			=> 'Le format de la date indiquée est trop long.',
	'TOO_LONG_ICQ'					=> 'Le numéro ICQ indiqué est trop long.',
	'TOO_LONG_INTERESTS'			=> 'Les centres d’intérêts indiqués sont trop longs.',
	'TOO_LONG_JABBER'				=> 'Le nom de compte Jabber indiqué est trop long.',
	'TOO_LONG_LOCATION'				=> 'La localisation indiquée est trop longue.',
	'TOO_LONG_MSN'					=> 'Le compte WLM indiqué est trop long.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Le mot de passe indiqué est trop long.',
	'TOO_LONG_OCCUPATION'			=> 'Les loisirs indiqués sont trop longs.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Le mot de passe de confirmation indiqué est trop long.',
	'TOO_LONG_USER_PASSWORD'		=> 'Le mot de passe indiqué est trop long.',
	'TOO_LONG_USERNAME'				=> 'Le nom d’utilisateur indiqué est trop long.',
	'TOO_LONG_EMAIL'				=> 'L’adresse e-mail indiquée est trop longue.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'L’adresse e-mail de confirmation indiquée est trop longue.',
	'TOO_LONG_WEBSITE'				=> 'L’adresse du site Internet indiquée est trop longue.',
	'TOO_LONG_YIM'					=> 'Le nom Yahoo! Messenger indiqué est trop long.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Vous avez sélectionné trop d’options de vote.',
	'TOO_SHORT' 					=> 'La valeur saisie est trop courte.',

	'TOO_SHORT_AIM'					=> 'Le pseudonyme AIM indiqué est trop court.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Le code de confirmation indiqué est trop court.',
	'TOO_SHORT_DATEFORMAT'			=> 'Le format de la date indiquée est trop courte.',
	'TOO_SHORT_ICQ'					=> 'Le numéro ICQ indiqué est trop court.',
	'TOO_SHORT_INTERESTS'			=> 'Les centres d’intérêts indiqués sont trop courts.',
	'TOO_SHORT_JABBER'				=> 'Le nom de compte Jabber indiqué est trop court.',
	'TOO_SHORT_LOCATION'			=> 'La localisation indiquée est trop courte.',
	'TOO_SHORT_MSN'					=> 'Le compte WLM indiqué est trop court.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Le mot de passe indiqué est trop court.',
	'TOO_SHORT_OCCUPATION'			=> 'Les loisirs indiqués sont trop courts.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Le mot de passe de confirmation indiqué est trop court.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Le mot de passe indiqué est trop court.',
	'TOO_SHORT_USERNAME'			=> 'Le nom d’utilisateur indiqué est trop court.',
	'TOO_SHORT_EMAIL'				=> 'L’adresse e-mail indiquée est trop courte.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'L’adresse e-mail de confirmation indiquée est trop courte.',
	'TOO_SHORT_WEBSITE'				=> 'L’adresse du site Internet indiquée est trop courte.',
	'TOO_SHORT_YIM'					=> 'Le nom Yahoo! Messenger indiqué est trop court.',

	'TOO_SMALL'						=> 'La valeur saisie est trop petite.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'La valeur du réglage <strong>Nombre maximum autorisé de destinataires par message privé</strong> que vous avez saisie est trop petite.',

	'TOPIC'				=> 'Sujet',
	'TOPICS'			=> 'Sujets',
	'TOPICS_UNAPPROVED'	=> 'Au moins un sujet dans ce forum n’est pas approuvé.',
	'TOPIC_ICON'		=> 'Icône de sujet',
	'TOPIC_LOCKED'		=> 'Ce sujet est verrouillé, vous ne pouvez pas éditer de messages ou poster d’autres réponses.',
	'TOPIC_LOCKED_SHORT'=> 'Sujet verrouillé',
	'TOPIC_MOVED'		=> 'Sujet déplacé',
	'TOPIC_REVIEW'		=> 'Revue du sujet',
	'TOPIC_TITLE'		=> 'Titre du sujet',
	'TOPIC_UNAPPROVED'	=> 'Ce sujet n’a pas été approuvé',
	'TOTAL_ATTACHMENTS'	=> 'Fichier(s) joint(s)',
	'TOTAL_LOG'			=> '1 entrée',
	'TOTAL_LOGS'		=> '%d entrées',
	'TOTAL_NO_PM'		=> '0 message privé',
	'TOTAL_PM'			=> '1 message privé',
	'TOTAL_PMS'			=> '%d messages privés',
	'TOTAL_POSTS'		=> 'Messages',
	'TOTAL_POSTS_OTHER'	=> '<strong>%d</strong> message(s)',
	'TOTAL_POSTS_ZERO'	=> '<strong>0</strong> message',
	'TOPIC_REPORTED'	=> 'Ce sujet a été rapporté',
	'TOTAL_TOPICS_OTHER'=> '<strong>%d</strong> sujet(s)',
	'TOTAL_TOPICS_ZERO'	=> '<strong>0</strong> sujet',
	'TOTAL_USERS_OTHER'	=> '<strong>%d</strong> membre(s)',
	'TOTAL_USERS_ZERO'	=> '<strong>0</strong> membre',
	'TRACKED_PHP_ERROR'	=> 'Suivi des erreurs PHP: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Impossible de déterminer les dimensions de l’image.',
	'UNABLE_TO_DELIVER_FILE'=> 'Impossible de charger l’image.',
	'UNKNOWN_BROWSER'		=> 'Navigateur inconnu',
	'UNMARK_ALL'			=> 'Tout décocher',
	'UNREAD_MESSAGES'		=> 'Messages non lus',
	'UNREAD_PM'				=> '<strong>%d</strong> message non lu',
	'UNREAD_PMS'			=> '<strong>%d</strong> messages non lus',
	'UNREAD_POST'			=> 'Message non lu',
	'UNREAD_POSTS'			=> 'Messages non lus',
	'UNWATCHED_FORUMS'		=> 'Vous ne surveillez plus les forums sélectionnés.',
	'UNWATCHED_TOPICS'		=> 'Vous ne surveillez plus les sujets sélectionnés.',
	'UNWATCHED_FORUMS_TOPICS'=> 'Vous ne surveillez plus les entrées sélectionnées.',
	'UPDATE'				=> 'Mise à jour',
	'UPLOAD_IN_PROGRESS'	=> 'Le chargement est actuellement en cours.',
	'URL_REDIRECT'			=> 'Si votre navigateur ne vous redirige pas automatiquement dans quelques instants, %scliquez ici pour être redirigé%s.',
	'USERGROUPS'			=> 'Groupes d’utilisateurs',
	'USERNAME'				=> 'Nom d’utilisateur',
	'USERNAMES'				=> 'Noms des utilisateurs',
	'USER_AVATAR'			=> 'Avatar de l’utilisateur',
	'USER_CANNOT_READ'		=> 'Vous ne pouvez pas lire les messages de ce forum.',
	'USER_POST'				=> '%d Message',
	'USER_POSTS'			=> '%d Messages',
	'USERS'					=> 'Utilisateurs',
	'USE_PERMISSIONS'		=> 'Tester les permissions de l’utilisateur',
	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Nous sommes désolés, mais vous n’êtes pas autorisé à utiliser cette fonctionnalité. Vous venez juste de vous inscrire, et il vous est nécessaire de participer plus pour utiliser cette fonctionnalité.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Vu',
	'VIEWING_FAQ'				=> 'Consulte la FAQ',
	'VIEWING_MEMBERS'			=> 'Consulte les informations d’un utilisateur',
	'VIEWING_ONLINE'			=> 'Regarde qui est en ligne',
	'VIEWING_MCP'				=> 'Consulte le panneau de modération',
	'VIEWING_MEMBER_PROFILE'	=> 'Consulte le profil d’un utilisateur',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Lit ses messages privés',
	'VIEWING_REGISTER'			=> 'S’enregistre',
	'VIEWING_UCP'				=> 'Consulte son panneau de l’utilisateur',
	'VIEWS'						=> 'Vus',
	'VIEW_BOOKMARKS'			=> 'Afficher les favoris',
	'VIEW_FORUM_LOGS'			=> 'Afficher le journal',
	'VIEW_LATEST_POST'			=> 'Voir le dernier message',
	'VIEW_NEWEST_POST'			=> 'Voir le premier message non lu',
	'VIEW_NOTES'				=> 'Notes sur l’utilisateur',
	'VIEW_ONLINE_TIME'			=> 'basées sur les utilisateurs actifs de la dernière minute',
	'VIEW_ONLINE_TIMES'			=> 'basées sur les utilisateurs actifs des %d dernières minutes',
	'VIEW_TOPIC'				=> 'Afficher le sujet',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Annonce: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Annonce globale: ',
	'VIEW_TOPIC_LOCKED'			=> 'Verrouillé: ',
	'VIEW_TOPIC_LOGS'			=> 'Voir les journaux',
	'VIEW_TOPIC_MOVED'			=> 'Déplacé: ',
	'VIEW_TOPIC_POLL'			=> 'Sondage: ',
	'VIEW_TOPIC_STICKY'			=> 'Post-it: ',
	'VISIT_WEBSITE'				=> 'Visiter le site Internet',

	'WARNINGS'			=> 'Avertissements',
	'WARN_USER'			=> 'Avertir l’utilisateur',
	'WELCOME_SUBJECT'	=> 'Bienvenue sur les forums %s',
	'WEBSITE'			=> 'Site Internet',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Qui est en ligne',
	'WRONG_PASSWORD'	=> 'Vous avez entré un mot de passe incorrect.',

	'WRONG_DATA_ICQ'			=> 'Le numéro que vous avez entré n’est pas un numéro ICQ valide.',
	'WRONG_DATA_JABBER'			=> 'Le nom que vous avez entré n’est pas un nom de compte Jabber valide.',
	'WRONG_DATA_LANG'			=> 'La langue que vous avez indiquée n’est pas valide.',
	'WRONG_DATA_WEBSITE'		=> 'L’adresse de site Internet doit être une URL valide, incluant le protocole. Par exemple http://www.exemple.com/.',
	'WROTE'						=> 'a écrit',

	'YEAR'				=> 'Année',
	'YEAR_MONTH_DAY'	=> '(AAAA-MM-JJ)',
	'YES'				=> 'Oui',
	'YIM'				=> 'YIM',	
	'YOU_LAST_VISIT'	=> 'Dernière visite le %s',
	'YOU_NEW_PM'		=> 'Un nouveau message privé vous attend dans votre boîte de réception.',
	'YOU_NEW_PMS'		=> 'De nouveaux messages privés vous attendent dans votre boîte de réception.',
	'YOU_NO_NEW_PM'		=> 'Aucun nouveau message privé en attente.',

	'datetime'			=> array(
		'TODAY'		=> 'Aujourd’hui',
		'TOMORROW'	=> 'Demain',
		'YESTERDAY'	=> 'Hier',
		'AGO'		=> array(
			0		=> 'il y a moins d’une minute',
			1		=> 'il y a %d minute',
			2		=> 'il y a %d minutes',
			60		=> 'il y a 1 heure',
		),

		'Sunday'	=> 'Dimanche',
		'Monday'	=> 'Lundi',
		'Tuesday'	=> 'Mardi',
		'Wednesday'	=> 'Mercredi',
		'Thursday'	=> 'Jeudi',
		'Friday'	=> 'Vendredi',
		'Saturday'	=> 'Samedi',

		'Sun'		=> 'Dim',
		'Mon'		=> 'Lun',
		'Tue'		=> 'Mar',
		'Wed'		=> 'Mer',
		'Thu'		=> 'Jeu',
		'Fri'		=> 'Ven',
		'Sat'		=> 'Sam',

		'January'	=> 'Janvier',
		'February'	=> 'Février',
		'March'		=> 'Mars',
		'April'		=> 'Avril',
		'May'		=> 'Mai',
		'June'		=> 'Juin',
		'July'		=> 'Juillet',
		'August'	=> 'Août',
		'September' => 'Septembre',
		'October'	=> 'Octobre',
		'November'	=> 'Novembre',
		'December'	=> 'Décembre',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Fév',
		'Mar'		=> 'Mar',
		'Apr'		=> 'Avr',
		'May_short'	=> 'Mai',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Juin',
		'Jul'		=> 'Juil',
		'Aug'		=> 'Aoû',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Oct',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Déc',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 heures',
		'-11'	=> 'UTC - 11 heures',
		'-10'	=> 'UTC - 10 heures',
		'-9.5'	=> 'UTC - 9:30 heures',
		'-9'	=> 'UTC - 9 heures',
		'-8'	=> 'UTC - 8 heures',
		'-7'	=> 'UTC - 7 heures',
		'-6'	=> 'UTC - 6 heures',
		'-5'	=> 'UTC - 5 heures',
		'-4.5' 	=> 'UTC - 4:30 heures',
		'-4'	=> 'UTC - 4 heures',
		'-3.5'	=> 'UTC - 3:30 heures',
		'-3'	=> 'UTC - 3 heures',
		'-2'	=> 'UTC - 2 heures',
		'-1'	=> 'UTC - 1 heure',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 heure',
		'2'		=> 'UTC + 2 heures',
		'3'		=> 'UTC + 3 heures',
		'3.5'	=> 'UTC + 3:30 heures',
		'4'		=> 'UTC + 4 heures',
		'4.5'	=> 'UTC + 4:30 heures',
		'5'		=> 'UTC + 5 heures',
		'5.5'	=> 'UTC + 5:30 heures',
		'5.75'	=> 'UTC + 5:45 heures',
		'6'		=> 'UTC + 6 heures',
		'6.5'	=> 'UTC + 6:30 heures',
		'7'		=> 'UTC + 7 heures',
		'8'		=> 'UTC + 8 heures',
		'8.75'	=> 'UTC + 8:45 heures',
		'9'		=> 'UTC + 9 heures',
		'9.5'	=> 'UTC + 9:30 heures',
		'10'	=> 'UTC + 10 heures',
		'10.5'	=> 'UTC + 10:30 heures',
		'11'	=> 'UTC + 11 heures',
		'11.5'	=> 'UTC + 11:30 heures',
		'12'	=> 'UTC + 12 heures',
		'12.75'	=> 'UTC + 12:45 heures',
		'13'	=> 'UTC + 13 heures',
		'14'	=> 'UTC + 14 heures',
		'dst'	=> '[ Heure d’été ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Île Baker',
		'-11'	=> '[UTC - 11] Niue, Samoa',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian, Île Cook',
		'-9.5'	=> '[UTC - 9:30] Îles Marquises',
		'-9'	=> '[UTC - 9] Alaska, Île Gambier',
		'-8'	=> '[UTC - 8] Pacifique',
		'-7'	=> '[UTC - 7] Montagnes Rocheuses',
		'-6'	=> '[UTC - 6] Centre',
		'-5'	=> '[UTC - 5] Est',
		'-4.5'   => '[UTC - 4:30] Venezuela',
		'-4'	=> '[UTC - 4] Atlantique',
		'-3.5'	=> '[UTC - 3:30] Terre-Neuve',
		'-3'	=> '[UTC - 3] Amazonie, Groenland Central',
		'-2'	=> '[UTC - 2] Fernando de Noronha, Géorgie du Sud &amp; les Îles Sandwich du Sud',
		'-1'	=> '[UTC - 1] Açores, Cap-Vert, Groenland de l’Est',
		'0'		=> '[UTC] Europe de l’Ouest, Méridien de Greenwich',
		'1'		=> '[UTC + 1] Europe Centrale, Afrique de l’Ouest',
		'2'		=> '[UTC + 2] Europe de l’Est, Afrique Centrale',
		'3'		=> '[UTC + 3] Moscou, Afrique de l’Est',
		'3.5'	=> '[UTC + 3:30] Iran',
		'4'		=> '[UTC + 4] Gulf, Samara',
		'4.5'	=> '[UTC + 4:30] Afghanistan',
		'5'		=> '[UTC + 5] Pakistan, Iekaterinbourg',
		'5.5'	=> '[UTC + 5:30] Inde, Sri Lanka',
		'5.75'	=> '[UTC + 5:45] Népal',
		'6'		=> '[UTC + 6] Bangladesh, Bhoutan, Novosibirsk',
		'6.5'	=> '[UTC + 6:30] Îles Cocos, Myanmar',
		'7'		=> '[UTC + 7] Indochine, Krasnoyarsk',
		'8'		=> '[UTC + 8] Chine, Australie de l’Ouest, Irkutsk',
		'8.75'	=> '[UTC + 8:45] Australie du Sud-Est',
		'9'		=> '[UTC + 9] Japon, Corée, Chita',
		'9.5'	=> '[UTC + 9:30] Australie Centrale',
		'10'	=> '[UTC + 10] Australie de l’Est, Vladivostok',
		'10.5'	=> '[UTC + 10:30] Lord Howe',
		'11'	=> '[UTC + 11] Île Solomon, Magadan',
		'11.5'	=> '[UTC + 11:30] Île Norfolk',
		'12'	=> '[UTC + 12] Nouvelle Zélande, Fiji, Kamchatka',
		'12.75'	=> '[UTC + 12:45] Îles Chatham',
		'13'	=> '[UTC + 13] Tongo, Îles Phoenix',
		'14'	=> '[UTC + 14] Île de Wight',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M j, \'y, H:i'		=> 'Jan 10, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Lun Jan 01, 2007 1:37 pm',
		'F j, Y, g:i a'		=> 'Janvier 10, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> '[Jours relatifs], 13:37 / 10 Jan 2007, 13:37',
		'|F j, Y|, g:i a'		=> '[Jours relatifs], 1:37 pm / Janvier 10, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D j M Y H:i', // Lun 10 Jan 2007 13:37

));

?>